/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.Conscrypt;
import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslProvider;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdkConscryptSslEngineInteropTest
extends SSLEngineTest {
    @Parameterized.Parameters(name="{index}: bufferType = {0}, combo = {1}, delegate = {2}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SSLEngineTest.BufferType type : SSLEngineTest.BufferType.values()) {
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true});
        }
        return params;
    }

    public JdkConscryptSslEngineInteropTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo combo, boolean delegate) {
        super(type, combo, delegate);
    }

    @BeforeClass
    public static void checkConscrypt() {
        Assume.assumeTrue((boolean)Conscrypt.isAvailable());
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected Provider serverSslContextProvider() {
        return Java8SslTestUtils.conscryptProvider();
    }

    @Override
    @Test
    @Ignore(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth();
    }

    @Override
    @Test
    @Ignore(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth();
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidClientException(cause) || JdkConscryptSslEngineInteropTest.causedBySSLException(cause);
    }

    @Override
    @Ignore(value="Ignore due bug in Conscrypt")
    public void testHandshakeSession() throws Exception {
    }
}

