/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.ssl.SslUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.junit.Assert;
import org.junit.Test;

public class SslUtilsTest {
    @Test
    public void testPacketLength() throws SSLException, NoSuchAlgorithmException {
        SSLEngine engineLE = SslUtilsTest.newEngine();
        SSLEngine engineBE = SslUtilsTest.newEngine();
        ByteBuffer empty = ByteBuffer.allocate(0);
        ByteBuffer cTOsLE = ByteBuffer.allocate(17408).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuffer cTOsBE = ByteBuffer.allocate(17408);
        Assert.assertTrue((engineLE.wrap(empty, cTOsLE).bytesProduced() > 0 ? 1 : 0) != 0);
        cTOsLE.flip();
        Assert.assertTrue((engineBE.wrap(empty, cTOsBE).bytesProduced() > 0 ? 1 : 0) != 0);
        cTOsBE.flip();
        ByteBuf bufferLE = Unpooled.buffer().order(ByteOrder.LITTLE_ENDIAN).writeBytes(cTOsLE);
        ByteBuf bufferBE = Unpooled.buffer().writeBytes(cTOsBE);
        Assert.assertEquals((long)SslUtils.getEncryptedPacketLength((ByteBuf)bufferBE, (int)0), (long)SslUtils.getEncryptedPacketLength((ByteBuf)bufferLE, (int)0));
        Assert.assertEquals((long)SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{bufferBE.nioBuffer()}, (int)0), (long)SslUtils.getEncryptedPacketLength((ByteBuffer[])new ByteBuffer[]{bufferLE.nioBuffer().order(ByteOrder.LITTLE_ENDIAN)}, (int)0));
    }

    private static SSLEngine newEngine() throws SSLException, NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        engine.beginHandshake();
        return engine;
    }

    @Test
    public void testIsTLSv13Cipher() {
        Assert.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_GCM_SHA256"));
        Assert.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_256_GCM_SHA384"));
        Assert.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_CHACHA20_POLY1305_SHA256"));
        Assert.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_CCM_SHA256"));
        Assert.assertTrue((boolean)SslUtils.isTLSv13Cipher((String)"TLS_AES_128_CCM_8_SHA256"));
        Assert.assertFalse((boolean)SslUtils.isTLSv13Cipher((String)"TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"));
    }
}

