/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.OpenSslErrorStackAssertSSLEngine;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.conscrypt.OpenSSLProvider;

final class Java8SslTestUtils {
    private Java8SslTestUtils() {
    }

    static void setSNIMatcher(SSLParameters parameters, final byte[] match) {
        SNIMatcher matcher = new SNIMatcher(0){

            @Override
            public boolean matches(SNIServerName sniServerName) {
                return Arrays.equals(match, sniServerName.getEncoded());
            }
        };
        parameters.setSNIMatchers(Collections.singleton(matcher));
    }

    static Provider conscryptProvider() {
        return new OpenSSLProvider();
    }

    static SSLEngine wrapSSLEngineForTesting(SSLEngine engine) {
        if (engine instanceof ReferenceCountedOpenSslEngine) {
            return new OpenSslErrorStackAssertSSLEngine((ReferenceCountedOpenSslEngine)engine);
        }
        return engine;
    }
}

