/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ResourcesUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ParameterizedSslHandlerTest {
    private final SslProvider clientProvider;
    private final SslProvider serverProvider;

    @Parameterized.Parameters(name="{index}: clientProvider={0}, {index}: serverProvider={1}")
    public static Collection<Object[]> data() {
        ArrayList<SslProvider> providers = new ArrayList<SslProvider>(3);
        if (OpenSsl.isAvailable()) {
            providers.add(SslProvider.OPENSSL);
            providers.add(SslProvider.OPENSSL_REFCNT);
        }
        providers.add(SslProvider.JDK);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslProvider cp : providers) {
            for (SslProvider sp : providers) {
                params.add(new Object[]{cp, sp});
            }
        }
        return params;
    }

    public ParameterizedSslHandlerTest(SslProvider clientProvider, SslProvider serverProvider) {
        this.clientProvider = clientProvider;
        this.serverProvider = serverProvider;
    }

    @Test(timeout=480000L)
    public void testCompositeBufSizeEstimationGuaranteesSynchronousWrite() throws CertificateException, SSLException, ExecutionException, InterruptedException {
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, true, true, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, true, true, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, true, false, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, true, false, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, false, true, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, false, true, false);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, false, false, true);
        ParameterizedSslHandlerTest.compositeBufSizeEstimationGuaranteesSynchronousWrite(this.serverProvider, this.clientProvider, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void compositeBufSizeEstimationGuaranteesSynchronousWrite(SslProvider serverProvider, SslProvider clientProvider, final boolean serverDisableWrapSize, final boolean letHandlerCreateServerEngine, final boolean letHandlerCreateClientEngine) throws CertificateException, SSLException, ExecutionException, InterruptedException {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(serverProvider).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(clientProvider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise donePromise = group.next().newPromise();
            int numComponents = 150;
            int desiredBytes = 16384;
            int singleComponentSize = 109;
            int expectedBytes = 16350;
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler;
                    SslHandler sslHandler = handler = letHandlerCreateServerEngine ? sslServerCtx.newHandler(ch.alloc()) : new SslHandler(sslServerCtx.newEngine(ch.alloc()));
                    if (serverDisableWrapSize) {
                        handler.setWrapDataSize(-1);
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private boolean sentData;
                        private Throwable writeCause;

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                SslHandshakeCompletionEvent sslEvt = (SslHandshakeCompletionEvent)evt;
                                if (sslEvt.isSuccess()) {
                                    CompositeByteBuf content = ctx.alloc().compositeDirectBuffer(150);
                                    for (int i = 0; i < 150; ++i) {
                                        ByteBuf buf = ctx.alloc().directBuffer(109);
                                        buf.writerIndex(buf.writerIndex() + 109);
                                        content.addComponent(true, buf);
                                    }
                                    ctx.writeAndFlush((Object)content).addListener((GenericFutureListener)new ChannelFutureListener(){

                                        public void operationComplete(ChannelFuture future) throws Exception {
                                            writeCause = future.cause();
                                            if (writeCause == null) {
                                                sentData = true;
                                            }
                                        }
                                    });
                                } else {
                                    donePromise.tryFailure(sslEvt.cause());
                                }
                            }
                            ctx.fireUserEventTriggered(evt);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("server exception sentData: " + this.sentData + " writeCause: " + this.writeCause, cause));
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("server closed sentData: " + this.sentData + " writeCause: " + this.writeCause));
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    if (letHandlerCreateClientEngine) {
                        ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                    } else {
                        ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(sslClientCtx.newEngine(ch.alloc()))});
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int bytesSeen;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            if (msg instanceof ByteBuf) {
                                this.bytesSeen += ((ByteBuf)msg).readableBytes();
                                if (this.bytesSeen == 16350) {
                                    donePromise.trySuccess(null);
                                }
                            }
                            ReferenceCountUtil.release((Object)msg);
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            SslHandshakeCompletionEvent sslEvt;
                            if (evt instanceof SslHandshakeCompletionEvent && !(sslEvt = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                                donePromise.tryFailure(sslEvt.cause());
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("client exception. bytesSeen: " + this.bytesSeen, cause));
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            donePromise.tryFailure((Throwable)new IllegalStateException("client closed. bytesSeen: " + this.bytesSeen));
                        }
                    }});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            donePromise.get();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
            ssc.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAlertProducedAndSend() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.serverProvider).trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                        throw new CertificateException();
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }};
            }
        }).clientAuth(ClientAuth.REQUIRE).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).keyManager(ResourcesUtil.getFile(this.getClass(), (String)"test.crt"), ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem")).sslProvider(this.clientProvider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise promise = group.next().newPromise();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            if (cause.getCause() instanceof SSLException) {
                                promise.trySuccess(null);
                            }
                        }
                    }});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            promise.syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test(timeout=30000L)
    public void testCloseNotify() throws Exception {
        this.testCloseNotify(5000L, false);
    }

    @Test(timeout=30000L)
    public void testCloseNotifyReceivedTimeout() throws Exception {
        this.testCloseNotify(100L, true);
    }

    @Test(timeout=30000L)
    public void testCloseNotifyNotWaitForResponse() throws Exception {
        this.testCloseNotify(0L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseNotify(final long closeNotifyReadTimeout, final boolean timeout) throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.serverProvider).protocols(new String[]{"TLSv1.2"}).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.clientProvider).protocols(new String[]{"TLSv1.2"}).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            final Promise clientPromise = group.next().newPromise();
            final Promise serverPromise = group.next().newPromise();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    SslHandler handler = sslServerCtx.newHandler(ch.alloc());
                    handler.setCloseNotifyReadTimeoutMillis(closeNotifyReadTimeout);
                    handler.sslCloseFuture().addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{serverPromise}));
                    handler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                        public void operationComplete(Future<Channel> future) {
                            if (!future.isSuccess()) {
                                serverPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    final AtomicBoolean closeSent = new AtomicBoolean();
                    if (timeout) {
                        ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (closeSent.get()) {
                                    ReferenceCountUtil.release((Object)msg);
                                } else {
                                    super.channelRead(ctx, msg);
                                }
                            }
                        }});
                    }
                    SslHandler handler = sslClientCtx.newHandler(ch.alloc());
                    handler.setCloseNotifyReadTimeoutMillis(closeNotifyReadTimeout);
                    handler.sslCloseFuture().addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{clientPromise}));
                    handler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                        public void operationComplete(Future<Channel> future) {
                            if (future.isSuccess()) {
                                closeSent.compareAndSet(false, true);
                                ((Channel)future.getNow()).close();
                            } else {
                                clientPromise.tryFailure(future.cause());
                            }
                        }
                    });
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            serverPromise.awaitUninterruptibly();
            clientPromise.awaitUninterruptibly();
            Assert.assertTrue((boolean)serverPromise.isSuccess());
            if (closeNotifyReadTimeout > 0L && !timeout) {
                Assert.assertTrue((boolean)clientPromise.isSuccess());
            } else {
                Assert.assertFalse((boolean)clientPromise.isSuccess());
            }
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }
}

