/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.Java9SslUtils;
import io.netty.handler.ssl.JdkSslEngine;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.internal.tcnative.SSL;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.junit.Assert;

final class OpenSslErrorStackAssertSSLEngine
extends JdkSslEngine
implements ReferenceCounted {
    OpenSslErrorStackAssertSSLEngine(ReferenceCountedOpenSslEngine engine) {
        super((SSLEngine)engine);
    }

    public String getPeerHost() {
        try {
            String string = this.getWrappedEngine().getPeerHost();
            return string;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public int getPeerPort() {
        try {
            int n = this.getWrappedEngine().getPeerPort();
            return n;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().wrap(src, dst);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult wrap(ByteBuffer[] srcs, ByteBuffer dst) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().wrap(srcs, dst);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult wrap(ByteBuffer[] byteBuffers, int i, int i1, ByteBuffer byteBuffer) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().wrap(byteBuffers, i, i1, byteBuffer);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().unwrap(src, dst);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().unwrap(src, dsts);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLEngineResult unwrap(ByteBuffer byteBuffer, ByteBuffer[] byteBuffers, int i, int i1) throws SSLException {
        try {
            SSLEngineResult sSLEngineResult = this.getWrappedEngine().unwrap(byteBuffer, byteBuffers, i, i1);
            return sSLEngineResult;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public Runnable getDelegatedTask() {
        try {
            Runnable runnable = this.getWrappedEngine().getDelegatedTask();
            return runnable;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void closeInbound() throws SSLException {
        try {
            this.getWrappedEngine().closeInbound();
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean isInboundDone() {
        try {
            boolean bl = this.getWrappedEngine().isInboundDone();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void closeOutbound() {
        try {
            this.getWrappedEngine().closeOutbound();
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean isOutboundDone() {
        try {
            boolean bl = this.getWrappedEngine().isOutboundDone();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            String[] stringArray = this.getWrappedEngine().getSupportedCipherSuites();
            return stringArray;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public String[] getEnabledCipherSuites() {
        try {
            String[] stringArray = this.getWrappedEngine().getEnabledCipherSuites();
            return stringArray;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setEnabledCipherSuites(String[] strings) {
        try {
            this.getWrappedEngine().setEnabledCipherSuites(strings);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public String[] getSupportedProtocols() {
        try {
            String[] stringArray = this.getWrappedEngine().getSupportedProtocols();
            return stringArray;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public String[] getEnabledProtocols() {
        try {
            String[] stringArray = this.getWrappedEngine().getEnabledProtocols();
            return stringArray;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setEnabledProtocols(String[] strings) {
        try {
            this.getWrappedEngine().setEnabledProtocols(strings);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public SSLSession getSession() {
        try {
            SSLSession sSLSession = this.getWrappedEngine().getSession();
            return sSLSession;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public SSLSession getHandshakeSession() {
        try {
            SSLSession sSLSession = this.getWrappedEngine().getHandshakeSession();
            return sSLSession;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void beginHandshake() throws SSLException {
        try {
            this.getWrappedEngine().beginHandshake();
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        try {
            SSLEngineResult.HandshakeStatus handshakeStatus = this.getWrappedEngine().getHandshakeStatus();
            return handshakeStatus;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setUseClientMode(boolean b) {
        try {
            this.getWrappedEngine().setUseClientMode(b);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean getUseClientMode() {
        try {
            boolean bl = this.getWrappedEngine().getUseClientMode();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setNeedClientAuth(boolean b) {
        try {
            this.getWrappedEngine().setNeedClientAuth(b);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean getNeedClientAuth() {
        try {
            boolean bl = this.getWrappedEngine().getNeedClientAuth();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setWantClientAuth(boolean b) {
        try {
            this.getWrappedEngine().setWantClientAuth(b);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean getWantClientAuth() {
        try {
            boolean bl = this.getWrappedEngine().getWantClientAuth();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setEnableSessionCreation(boolean b) {
        try {
            this.getWrappedEngine().setEnableSessionCreation(b);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public boolean getEnableSessionCreation() {
        try {
            boolean bl = this.getWrappedEngine().getEnableSessionCreation();
            return bl;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public SSLParameters getSSLParameters() {
        try {
            SSLParameters sSLParameters = this.getWrappedEngine().getSSLParameters();
            return sSLParameters;
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public void setSSLParameters(SSLParameters params) {
        try {
            this.getWrappedEngine().setSSLParameters(params);
        }
        finally {
            OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
        }
    }

    public String getApplicationProtocol() {
        if (PlatformDependent.javaVersion() >= 9) {
            try {
                String string = Java9SslUtils.getApplicationProtocol((SSLEngine)this.getWrappedEngine());
                return string;
            }
            finally {
                OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
            }
        }
        throw new UnsupportedOperationException();
    }

    public String getHandshakeApplicationProtocol() {
        if (PlatformDependent.javaVersion() >= 9) {
            try {
                String string = Java9SslUtils.getHandshakeApplicationProtocol((SSLEngine)this.getWrappedEngine());
                return string;
            }
            finally {
                OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLEngine, List<String>, String> selector) {
        if (PlatformDependent.javaVersion() >= 9) {
            try {
                Java9SslUtils.setHandshakeApplicationProtocolSelector((SSLEngine)this.getWrappedEngine(), selector);
            }
            finally {
                OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
            }
        }
        throw new UnsupportedOperationException();
    }

    public BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector() {
        if (PlatformDependent.javaVersion() >= 9) {
            try {
                BiFunction biFunction = Java9SslUtils.getHandshakeApplicationProtocolSelector((SSLEngine)this.getWrappedEngine());
                return biFunction;
            }
            finally {
                OpenSslErrorStackAssertSSLEngine.assertErrorStackEmpty();
            }
        }
        throw new UnsupportedOperationException();
    }

    public int refCnt() {
        return this.getWrappedEngine().refCnt();
    }

    public OpenSslErrorStackAssertSSLEngine retain() {
        this.getWrappedEngine().retain();
        return this;
    }

    public OpenSslErrorStackAssertSSLEngine retain(int increment) {
        this.getWrappedEngine().retain(increment);
        return this;
    }

    public OpenSslErrorStackAssertSSLEngine touch() {
        this.getWrappedEngine().touch();
        return this;
    }

    public OpenSslErrorStackAssertSSLEngine touch(Object hint) {
        this.getWrappedEngine().touch(hint);
        return this;
    }

    public boolean release() {
        return this.getWrappedEngine().release();
    }

    public boolean release(int decrement) {
        return this.getWrappedEngine().release(decrement);
    }

    public String getNegotiatedApplicationProtocol() {
        return this.getWrappedEngine().getNegotiatedApplicationProtocol();
    }

    void setNegotiatedApplicationProtocol(String applicationProtocol) {
        throw new UnsupportedOperationException();
    }

    public ReferenceCountedOpenSslEngine getWrappedEngine() {
        return (ReferenceCountedOpenSslEngine)super.getWrappedEngine();
    }

    private static void assertErrorStackEmpty() {
        Assert.assertEquals((String)"SSL error stack non-empty", (long)0L, (long)SSL.getLastErrorNumber());
    }
}

