/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SslHandler
extends ByteToMessageDecoder
implements ChannelOutboundHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SslHandler.class);
    private static final Pattern IGNORABLE_CLASS_IN_STACK = Pattern.compile("^.*(?:Socket|Datagram|Sctp|Udt)Channel.*$");
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*(?:reset|closed|abort|broken)|broken.*pipe).*$", 2);
    private static final SSLException SSLENGINE_CLOSED = new SSLException("SSLEngine closed already");
    private static final SSLException HANDSHAKE_TIMED_OUT = new SSLException("handshake timed out");
    private static final ClosedChannelException CHANNEL_CLOSED = new ClosedChannelException();
    private volatile ChannelHandlerContext ctx;
    private final SSLEngine engine;
    private final Executor delegatedTaskExecutor;
    private final boolean startTls;
    private boolean sentFirstMessage;
    private final LazyChannelPromise handshakePromise = new LazyChannelPromise();
    private final LazyChannelPromise sslCloseFuture = new LazyChannelPromise();
    private final CloseNotifyListener closeNotifyWriteListener = new CloseNotifyListener();
    private final Queue<PendingWrite> pendingUnencryptedWrites = new ArrayDeque<PendingWrite>();
    private volatile long handshakeTimeoutMillis = 10000L;
    private volatile long closeNotifyTimeoutMillis = 3000L;
    private ByteBuf decodeOut;

    public SslHandler(SSLEngine engine) {
        this(engine, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, boolean startTls) {
        this(engine, startTls, (Executor)ImmediateExecutor.INSTANCE);
    }

    public SslHandler(SSLEngine engine, Executor delegatedTaskExecutor) {
        this(engine, false, delegatedTaskExecutor);
    }

    public SslHandler(SSLEngine engine, boolean startTls, Executor delegatedTaskExecutor) {
        if (engine == null) {
            throw new NullPointerException("engine");
        }
        if (delegatedTaskExecutor == null) {
            throw new NullPointerException("delegatedTaskExecutor");
        }
        this.engine = engine;
        this.delegatedTaskExecutor = delegatedTaskExecutor;
        this.startTls = startTls;
    }

    public long getHandshakeTimeoutMillis() {
        return this.handshakeTimeoutMillis;
    }

    public void setHandshakeTimeout(long handshakeTimeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.setHandshakeTimeoutMillis(unit.toMillis(handshakeTimeout));
    }

    public void setHandshakeTimeoutMillis(long handshakeTimeoutMillis) {
        if (handshakeTimeoutMillis < 0L) {
            throw new IllegalArgumentException("handshakeTimeoutMillis: " + handshakeTimeoutMillis + " (expected: >= 0)");
        }
        this.handshakeTimeoutMillis = handshakeTimeoutMillis;
    }

    public long getCloseNotifyTimeoutMillis() {
        return this.closeNotifyTimeoutMillis;
    }

    public void setCloseNotifyTimeout(long closeNotifyTimeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.setCloseNotifyTimeoutMillis(unit.toMillis(closeNotifyTimeout));
    }

    public void setCloseNotifyTimeoutMillis(long closeNotifyTimeoutMillis) {
        if (closeNotifyTimeoutMillis < 0L) {
            throw new IllegalArgumentException("closeNotifyTimeoutMillis: " + closeNotifyTimeoutMillis + " (expected: >= 0)");
        }
        this.closeNotifyTimeoutMillis = closeNotifyTimeoutMillis;
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public Future<Channel> handshakeFuture() {
        return this.handshakePromise;
    }

    public ChannelFuture close() {
        return this.close(this.ctx.newPromise());
    }

    public ChannelFuture close(final ChannelPromise future) {
        final ChannelHandlerContext ctx = this.ctx;
        ctx.executor().execute(new Runnable(){

            @Override
            public void run() {
                block2: {
                    SslHandler.this.engine.closeOutbound();
                    future.addListener((GenericFutureListener)SslHandler.this.closeNotifyWriteListener);
                    try {
                        SslHandler.this.write(ctx, (MessageList<Object>)MessageList.newInstance((Object)Unpooled.EMPTY_BUFFER), future);
                    }
                    catch (Exception e) {
                        if (future.tryFailure((Throwable)e)) break block2;
                        logger.warn("flush() raised a masked exception.", (Throwable)e);
                    }
                }
            }
        });
        return future;
    }

    public Future<Channel> sslCloseFuture() {
        return this.sslCloseFuture;
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) throws Exception {
        if (this.decodeOut != null) {
            this.decodeOut.release();
        }
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, true);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.closeOutboundAndChannel(ctx, promise, false);
    }

    public void read(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, MessageList<Object> msgs, ChannelPromise promise) throws Exception {
        if (this.startTls && !this.sentFirstMessage) {
            this.sentFirstMessage = true;
            ctx.write(msgs, promise);
            return;
        }
        for (int i = 0; i < msgs.size(); ++i) {
            ByteBuf msg = (ByteBuf)msgs.get(i);
            ChannelPromise cp = i + 1 == msgs.size() ? promise : ctx.newPromise();
            this.pendingUnencryptedWrites.add(new PendingWrite(msg, cp));
        }
        this.flush0(ctx);
    }

    private void flush0(ChannelHandlerContext ctx) throws SSLException {
        boolean unwrapLater = false;
        PendingWrite pending = null;
        ByteBuf out = null;
        try {
            block13: while (true) {
                if (out == null) {
                    out = ctx.alloc().buffer();
                }
                if ((pending = this.pendingUnencryptedWrites.peek()) == null) break;
                SSLEngineResult result = SslHandler.wrap(this.engine, pending.buf, out);
                if (!pending.buf.isReadable()) {
                    pending.buf.release();
                    this.pendingUnencryptedWrites.remove();
                }
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    PendingWrite w;
                    boolean failed = false;
                    while ((w = this.pendingUnencryptedWrites.poll()) != null) {
                        failed = true;
                        w.fail(SSLENGINE_CLOSED);
                    }
                    if (failed) {
                        ctx.fireExceptionCaught((Throwable)SSLENGINE_CLOSED);
                    }
                    return;
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        if (!pending.buf.isReadable()) {
                            ctx.write((Object)out, pending.promise);
                        } else {
                            ctx.write((Object)out);
                        }
                        out = ctx.alloc().buffer();
                        continue block13;
                    }
                    case NEED_UNWRAP: {
                        if (!this.internalBuffer().isReadable()) break;
                        unwrapLater = true;
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        continue block13;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        continue block13;
                    }
                    case NOT_HANDSHAKING: {
                        if (!this.internalBuffer().isReadable()) break;
                        unwrapLater = true;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
                if (result.bytesConsumed() == 0 && result.bytesProduced() == 0) break;
            }
            if (unwrapLater) {
                this.decode0(ctx);
            }
        }
        catch (SSLException e) {
            this.setHandshakeFailure(e);
            throw e;
        }
        finally {
            if (out != null && out.isReadable()) {
                if (pending != null && !pending.buf.isReadable()) {
                    ctx.write((Object)out, pending.promise);
                } else {
                    ctx.write((Object)out);
                }
                out = null;
            } else if (pending != null && !pending.buf.isReadable()) {
                pending.promise.setSuccess();
            }
            if (out != null) {
                out.release();
            }
        }
    }

    private void flushNonAppData0(ChannelHandlerContext ctx) throws SSLException {
        boolean unwrapLater = false;
        ByteBuf out = null;
        try {
            block13: while (true) {
                SSLEngineResult result;
                if (out == null) {
                    out = ctx.alloc().buffer();
                }
                if ((result = SslHandler.wrap(this.engine, Unpooled.EMPTY_BUFFER, out)).bytesProduced() > 0) {
                    ctx.write((Object)out);
                    out = null;
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        continue block13;
                    }
                    case NEED_UNWRAP: {
                        if (!this.internalBuffer().isReadable()) break;
                        unwrapLater = true;
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        continue block13;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        this.flush0(ctx);
                        return;
                    }
                    case NOT_HANDSHAKING: {
                        if (this.internalBuffer().isReadable()) {
                            unwrapLater = true;
                        }
                        this.flush0(ctx);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
                if (result.bytesProduced() == 0) break;
            }
            if (unwrapLater) {
                this.decode0(ctx);
            }
        }
        catch (SSLException e) {
            this.setHandshakeFailure(e);
            throw e;
        }
        finally {
            if (out != null) {
                out.release();
            }
        }
    }

    private static SSLEngineResult wrap(SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        SSLEngineResult result;
        ByteBuffer in0 = in.nioBuffer();
        while (true) {
            ByteBuffer out0 = out.nioBuffer(out.writerIndex(), out.writableBytes());
            result = engine.wrap(in0, out0);
            in.skipBytes(result.bytesConsumed());
            out.writerIndex(out.writerIndex() + result.bytesProduced());
            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            out.ensureWritable(engine.getSession().getPacketBufferSize());
        }
        return result;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.setHandshakeFailure(CHANNEL_CLOSED);
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.ignoreException(cause)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Swallowing a harmless 'connection reset by peer / broken pipe' error that occurred while writing close_notify in response to the peer's close_notify", cause);
            }
            if (ctx.channel().isActive()) {
                ctx.close();
            }
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    private boolean ignoreException(Throwable t) {
        if (!(t instanceof SSLException) && t instanceof IOException && this.sslCloseFuture.isDone()) {
            StackTraceElement[] elements;
            String message = String.valueOf(t.getMessage()).toLowerCase();
            if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                return true;
            }
            for (StackTraceElement element : elements = t.getStackTrace()) {
                String classname = element.getClassName();
                String methodname = element.getMethodName();
                if (classname.startsWith("io.netty.") || !"read".equals(methodname)) continue;
                if (IGNORABLE_CLASS_IN_STACK.matcher(classname).matches()) {
                    return true;
                }
                try {
                    Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(classname);
                    if (SocketChannel.class.isAssignableFrom(clazz) || DatagramChannel.class.isAssignableFrom(clazz)) {
                        return true;
                    }
                    if (PlatformDependent.javaVersion() >= 7 && "com.sun.nio.sctp.SctpChannel".equals(clazz.getSuperclass().getName())) {
                        return true;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static boolean isEncrypted(ByteBuf buffer) {
        return SslHandler.getEncryptedPacketLength(buffer) != -1;
    }

    private static int getEncryptedPacketLength(ByteBuf buffer) {
        boolean tls;
        if (buffer.readableBytes() < 5) {
            throw new IllegalArgumentException("buffer must have at least 5 readable bytes");
        }
        int packetLength = 0;
        switch (buffer.getUnsignedByte(buffer.readerIndex())) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                tls = true;
                break;
            }
            default: {
                tls = false;
            }
        }
        if (tls) {
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + 1);
            if (majorVersion == 3) {
                packetLength = (SslHandler.getShort(buffer, buffer.readerIndex() + 3) & 0xFFFF) + 5;
                if (packetLength <= 5) {
                    tls = false;
                }
            } else {
                tls = false;
            }
        }
        if (!tls) {
            boolean sslv2 = true;
            int headerLength = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0 ? 2 : 3;
            short majorVersion = buffer.getUnsignedByte(buffer.readerIndex() + headerLength + 1);
            if (majorVersion == 2 || majorVersion == 3) {
                packetLength = headerLength == 2 ? (SslHandler.getShort(buffer, buffer.readerIndex()) & Short.MAX_VALUE) + 2 : (SslHandler.getShort(buffer, buffer.readerIndex()) & 0x3FFF) + 3;
                if (packetLength <= headerLength) {
                    sslv2 = false;
                }
            } else {
                sslv2 = false;
            }
            if (!sslv2) {
                return -1;
            }
        }
        return packetLength;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, MessageList<Object> out) throws Exception {
        this.decode0(ctx);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void decode0(ChannelHandlerContext ctx) throws SSLException {
        ByteBuf in = this.internalBuffer();
        if (in.readableBytes() < 5) {
            return;
        }
        int packetLength = SslHandler.getEncryptedPacketLength(in);
        if (packetLength == -1) {
            NotSslRecordException e = new NotSslRecordException("not an SSL/TLS record: " + ByteBufUtil.hexDump((ByteBuf)in));
            in.skipBytes(in.readableBytes());
            ctx.fireExceptionCaught((Throwable)e);
            this.setHandshakeFailure(e);
            return;
        }
        assert (packetLength > 0);
        boolean wrapLater = false;
        int bytesProduced = 0;
        try {
            block16: while (true) {
                if (this.decodeOut == null) {
                    this.decodeOut = ctx.alloc().buffer();
                }
                SSLEngineResult result = SslHandler.unwrap(this.engine, in, this.decodeOut);
                bytesProduced += result.bytesProduced();
                switch (result.getStatus()) {
                    case CLOSED: {
                        this.sslCloseFuture.trySuccess(ctx.channel());
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        break block16;
                    }
                }
                switch (result.getHandshakeStatus()) {
                    case NEED_UNWRAP: {
                        break;
                    }
                    case NEED_WRAP: {
                        wrapLater = true;
                        break;
                    }
                    case NEED_TASK: {
                        this.runDelegatedTasks();
                        break;
                    }
                    case FINISHED: {
                        this.setHandshakeSuccess();
                        wrapLater = true;
                        continue block16;
                    }
                    case NOT_HANDSHAKING: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown handshake status: " + (Object)((Object)result.getHandshakeStatus()));
                    }
                }
                if (result.bytesConsumed() == 0 && result.bytesProduced() == 0) break;
            }
            if (!wrapLater) return;
            this.flushNonAppData0(ctx);
            return;
        }
        catch (SSLException e) {
            this.setHandshakeFailure(e);
            throw e;
        }
        finally {
            if (bytesProduced > 0) {
                ByteBuf decodeOut = this.decodeOut;
                this.decodeOut = null;
                ctx.fireMessageReceived((Object)decodeOut);
            }
        }
    }

    private static short getShort(ByteBuf buf, int offset) {
        return (short)(buf.getByte(offset) << 8 | buf.getByte(offset + 1) & 0xFF);
    }

    private static SSLEngineResult unwrap(SSLEngine engine, ByteBuf in, ByteBuf out) throws SSLException {
        SSLEngineResult result;
        ByteBuffer in0 = in.nioBuffer();
        block3: while (true) {
            ByteBuffer out0 = out.nioBuffer(out.writerIndex(), out.writableBytes());
            result = engine.unwrap(in0, out0);
            in.skipBytes(result.bytesConsumed());
            out.writerIndex(out.writerIndex() + result.bytesProduced());
            switch (result.getStatus()) {
                case BUFFER_OVERFLOW: {
                    out.ensureWritable(engine.getSession().getApplicationBufferSize());
                    continue block3;
                }
            }
            break;
        }
        return result;
    }

    private void runDelegatedTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            this.delegatedTaskExecutor.execute(task);
        }
    }

    private void setHandshakeSuccess() {
        if (this.handshakePromise.trySuccess(this.ctx.channel())) {
            this.ctx.fireUserEventTriggered((Object)SslHandshakeCompletionEvent.SUCCESS);
        }
    }

    private void setHandshakeFailure(Throwable cause) {
        PendingWrite write;
        block4: {
            this.engine.closeOutbound();
            boolean disconnected = cause instanceof ClosedChannelException;
            try {
                this.engine.closeInbound();
            }
            catch (SSLException e) {
                if (!disconnected) {
                    logger.debug("SSLEngine.closeInbound() raised an exception after a handshake failure.", (Throwable)e);
                }
                if (this.closeNotifyWriteListener.done) break block4;
                logger.debug("SSLEngine.closeInbound() raised an exception due to closed connection.", (Throwable)e);
            }
        }
        this.notifyHandshakeFailure(cause);
        while ((write = this.pendingUnencryptedWrites.poll()) != null) {
            write.fail(cause);
        }
    }

    private void notifyHandshakeFailure(Throwable cause) {
        if (this.handshakePromise.tryFailure(cause)) {
            this.ctx.fireUserEventTriggered((Object)new SslHandshakeCompletionEvent(cause));
            this.ctx.pipeline().fireExceptionCaught(cause);
        }
    }

    private void closeOutboundAndChannel(ChannelHandlerContext ctx, ChannelPromise promise, boolean disconnect) throws Exception {
        if (!ctx.channel().isActive()) {
            if (disconnect) {
                ctx.disconnect(promise);
            } else {
                ctx.close(promise);
            }
            return;
        }
        this.engine.closeOutbound();
        ChannelPromise closeNotifyFuture = ctx.newPromise().addListener((GenericFutureListener)this.closeNotifyWriteListener);
        this.write(ctx, (MessageList<Object>)MessageList.newInstance((Object)Unpooled.EMPTY_BUFFER), closeNotifyFuture);
        this.safeClose(ctx, (ChannelFuture)closeNotifyFuture, promise);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        if (ctx.channel().isActive()) {
            this.handshake0();
        }
    }

    private Future<Channel> handshake0() {
        final io.netty.util.concurrent.ScheduledFuture timeoutFuture = this.handshakeTimeoutMillis > 0L ? this.ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                if (SslHandler.this.handshakePromise.isDone()) {
                    return;
                }
                SslHandler.this.notifyHandshakeFailure(HANDSHAKE_TIMED_OUT);
            }
        }, this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        this.handshakePromise.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            public void operationComplete(Future<Channel> f) throws Exception {
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
            }
        });
        try {
            this.engine.beginHandshake();
            this.flushNonAppData0(this.ctx);
        }
        catch (Exception e) {
            this.notifyHandshakeFailure(e);
        }
        return this.handshakePromise;
    }

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        if (!this.startTls && this.engine.getUseClientMode()) {
            this.handshake0().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    if (!future.isSuccess()) {
                        future.cause().printStackTrace();
                        ctx.close();
                    }
                }
            });
        }
        ctx.fireChannelActive();
    }

    private void safeClose(final ChannelHandlerContext ctx, ChannelFuture flushFuture, final ChannelPromise promise) {
        if (!ctx.channel().isActive()) {
            ctx.close(promise);
            return;
        }
        io.netty.util.concurrent.ScheduledFuture timeoutFuture = this.closeNotifyTimeoutMillis > 0L ? ctx.executor().schedule(new Runnable(){

            @Override
            public void run() {
                logger.warn(ctx.channel() + " last write attempt timed out. Force-closing the connection.");
                ctx.close(promise);
            }
        }, this.closeNotifyTimeoutMillis, TimeUnit.MILLISECONDS) : null;
        flushFuture.addListener((GenericFutureListener)new ChannelFutureListener((ScheduledFuture)timeoutFuture, ctx, promise){
            final /* synthetic */ ScheduledFuture val$timeoutFuture;
            final /* synthetic */ ChannelHandlerContext val$ctx;
            final /* synthetic */ ChannelPromise val$promise;
            {
                this.val$timeoutFuture = scheduledFuture;
                this.val$ctx = channelHandlerContext;
                this.val$promise = channelPromise;
            }

            public void operationComplete(ChannelFuture f) throws Exception {
                if (this.val$timeoutFuture != null) {
                    this.val$timeoutFuture.cancel(false);
                }
                if (this.val$ctx.channel().isActive()) {
                    this.val$ctx.close(this.val$promise);
                }
            }
        });
    }

    static {
        SSLENGINE_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        HANDSHAKE_TIMED_OUT.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        CHANNEL_CLOSED.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
    }

    private static final class PendingWrite {
        final ByteBuf buf;
        final ChannelPromise promise;

        PendingWrite(ByteBuf buf, ChannelPromise promise) {
            this.buf = buf;
            this.promise = promise;
        }

        void fail(Throwable cause) {
            this.buf.release();
            this.promise.setFailure(cause);
        }
    }

    private final class LazyChannelPromise
    extends DefaultPromise<Channel> {
        private LazyChannelPromise() {
        }

        protected EventExecutor executor() {
            if (SslHandler.this.ctx == null) {
                throw new IllegalStateException();
            }
            return SslHandler.this.ctx.executor();
        }
    }

    private static final class CloseNotifyListener
    implements ChannelFutureListener {
        boolean done;

        private CloseNotifyListener() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                if (this.done) {
                    throw new IllegalStateException("notified twice");
                }
                this.done = true;
            }
        }
    }
}

