/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.proxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.socksx.v5.DefaultSocks5CommandResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5InitialResponse;
import io.netty.handler.codec.socksx.v5.DefaultSocks5PasswordAuthResponse;
import io.netty.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.handler.codec.socksx.v5.Socks5CommandRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5CommandStatus;
import io.netty.handler.codec.socksx.v5.Socks5CommandType;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.handler.codec.socksx.v5.Socks5InitialRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthRequestDecoder;
import io.netty.handler.codec.socksx.v5.Socks5PasswordAuthStatus;
import io.netty.handler.codec.socksx.v5.Socks5ServerEncoder;
import io.netty.handler.proxy.ProxyServer;
import io.netty.handler.proxy.TestMode;
import io.netty.handler.proxy.UnresponsiveHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

final class Socks5ProxyServer
extends ProxyServer {
    private static final String ENCODER = "encoder";
    private static final String DECODER = "decoder";

    Socks5ProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination) {
        super(useSsl, testMode, destination);
    }

    Socks5ProxyServer(boolean useSsl, TestMode testMode, InetSocketAddress destination, String username, String password) {
        super(useSsl, testMode, destination, username, password);
    }

    @Override
    protected void configure(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        switch (this.testMode) {
            case INTERMEDIARY: {
                p.addLast(DECODER, (ChannelHandler)new Socks5InitialRequestDecoder());
                p.addLast(ENCODER, (ChannelHandler)Socks5ServerEncoder.DEFAULT);
                p.addLast(new ChannelHandler[]{new Socks5IntermediaryHandler()});
                break;
            }
            case TERMINAL: {
                p.addLast(DECODER, (ChannelHandler)new Socks5InitialRequestDecoder());
                p.addLast(ENCODER, (ChannelHandler)Socks5ServerEncoder.DEFAULT);
                p.addLast(new ChannelHandler[]{new Socks5TerminalHandler()});
                break;
            }
            case UNRESPONSIVE: {
                p.addLast(new ChannelHandler[]{UnresponsiveHandler.INSTANCE});
            }
        }
    }

    boolean authenticate(ChannelHandlerContext ctx, Object msg) {
        if (this.username == null) {
            ctx.pipeline().replace(DECODER, DECODER, (ChannelHandler)new Socks5CommandRequestDecoder());
            ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.NO_AUTH));
            return true;
        }
        if (msg instanceof Socks5InitialRequest) {
            ctx.pipeline().replace(DECODER, DECODER, (ChannelHandler)new Socks5PasswordAuthRequestDecoder());
            ctx.write((Object)new DefaultSocks5InitialResponse(Socks5AuthMethod.PASSWORD));
            return false;
        }
        Socks5PasswordAuthRequest req = (Socks5PasswordAuthRequest)msg;
        if (req.username().equals(this.username) && req.password().equals(this.password)) {
            ctx.pipeline().replace(DECODER, DECODER, (ChannelHandler)new Socks5CommandRequestDecoder());
            ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.SUCCESS));
            return true;
        }
        ctx.pipeline().replace(DECODER, DECODER, (ChannelHandler)new Socks5PasswordAuthRequestDecoder());
        ctx.write((Object)new DefaultSocks5PasswordAuthResponse(Socks5PasswordAuthStatus.FAILURE));
        return false;
    }

    private final class Socks5TerminalHandler
    extends ProxyServer.TerminalHandler {
        private boolean authenticated;

        private Socks5TerminalHandler() {
            super(Socks5ProxyServer.this);
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            DefaultSocks5CommandResponse res;
            if (!this.authenticated) {
                this.authenticated = Socks5ProxyServer.this.authenticate(ctx, msg);
                return false;
            }
            Socks5CommandRequest req = (Socks5CommandRequest)msg;
            MatcherAssert.assertThat((Object)req.type(), (Matcher)Matchers.is((Object)Socks5CommandType.CONNECT));
            ctx.pipeline().addBefore(ctx.name(), "lineDecoder", (ChannelHandler)new LineBasedFrameDecoder(64, false, true));
            boolean sendGreeting = false;
            if (!req.dstAddr().equals(Socks5ProxyServer.this.destination.getHostString()) || req.dstPort() != Socks5ProxyServer.this.destination.getPort()) {
                res = new DefaultSocks5CommandResponse(Socks5CommandStatus.FORBIDDEN, Socks5AddressType.IPv4);
            } else {
                res = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4);
                sendGreeting = true;
            }
            ctx.write((Object)res);
            ctx.pipeline().remove(Socks5ProxyServer.ENCODER);
            ctx.pipeline().remove(Socks5ProxyServer.DECODER);
            if (sendGreeting) {
                ctx.write((Object)Unpooled.copiedBuffer((CharSequence)"0\n", (Charset)CharsetUtil.US_ASCII));
            }
            return true;
        }
    }

    private final class Socks5IntermediaryHandler
    extends ProxyServer.IntermediaryHandler {
        private boolean authenticated;
        private SocketAddress intermediaryDestination;

        private Socks5IntermediaryHandler() {
            super(Socks5ProxyServer.this);
        }

        @Override
        protected boolean handleProxyProtocol(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!this.authenticated) {
                this.authenticated = Socks5ProxyServer.this.authenticate(ctx, msg);
                return false;
            }
            Socks5CommandRequest req = (Socks5CommandRequest)msg;
            MatcherAssert.assertThat((Object)req.type(), (Matcher)Matchers.is((Object)Socks5CommandType.CONNECT));
            DefaultSocks5CommandResponse res = new DefaultSocks5CommandResponse(Socks5CommandStatus.SUCCESS, Socks5AddressType.IPv4);
            this.intermediaryDestination = SocketUtils.socketAddress((String)req.dstAddr(), (int)req.dstPort());
            ctx.write((Object)res);
            ctx.pipeline().remove(Socks5ProxyServer.ENCODER);
            ctx.pipeline().remove(Socks5ProxyServer.DECODER);
            return true;
        }

        @Override
        protected SocketAddress intermediaryDestination() {
            return this.intermediaryDestination;
        }
    }
}

