/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.stomp.websocket.StompChatHandler;
import io.netty.example.stomp.websocket.StompVersion;
import io.netty.example.stomp.websocket.StompWebSocketClientPageHandler;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import io.netty.handler.codec.stomp.StompSubframeEncoder;
import java.util.List;

@ChannelHandler.Sharable
public class StompWebSocketProtocolCodec
extends MessageToMessageCodec<WebSocketFrame, ByteBuf> {
    private final StompChatHandler stompChatHandler = new StompChatHandler();

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            StompVersion stompVersion = StompVersion.findBySubProtocol(((WebSocketServerProtocolHandler.HandshakeComplete)evt).selectedSubprotocol());
            ctx.channel().attr(StompVersion.CHANNEL_ATTRIBUTE_KEY).set((Object)stompVersion);
            ctx.pipeline().addLast(new ChannelHandler[]{new StompSubframeDecoder()}).addLast(new ChannelHandler[]{new StompSubframeEncoder()}).addLast(new ChannelHandler[]{new StompSubframeAggregator(65536)}).addLast(new ChannelHandler[]{this.stompChatHandler}).remove((ChannelHandler)StompWebSocketClientPageHandler.INSTANCE);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf stompFrame, List<Object> out) {
        out.add(new TextWebSocketFrame(stompFrame.retain()));
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame webSocketFrame, List<Object> out) {
        if (webSocketFrame instanceof TextWebSocketFrame) {
            out.add(webSocketFrame.content().retain());
        } else {
            ctx.close();
        }
    }
}

