/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http2.helloworld.client.Http2ClientInitializer;
import io.netty.example.http2.helloworld.client.Http2SettingsHandler;
import io.netty.example.http2.helloworld.client.HttpResponseHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.util.concurrent.TimeUnit;

public final class Http2Client {
    static final boolean SSL = System.getProperty("ssl") != null;
    static final String HOST = System.getProperty("host", "127.0.0.1");
    static final int PORT = Integer.parseInt(System.getProperty("port", SSL ? "8443" : "8080"));
    static final String URL = System.getProperty("url", "/whatever");
    static final String URL2 = System.getProperty("url2");
    static final String URL2DATA = System.getProperty("url2data", "test data!");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SslContext sslCtx;
        if (SSL) {
            SslProvider provider = OpenSsl.isAlpnSupported() ? SslProvider.OPENSSL : SslProvider.JDK;
            sslCtx = SslContextBuilder.forClient().sslProvider(provider).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"})).build();
        } else {
            sslCtx = null;
        }
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        Http2ClientInitializer initializer = new Http2ClientInitializer(sslCtx, Integer.MAX_VALUE);
        try {
            DefaultFullHttpRequest request;
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.remoteAddress(HOST, PORT);
            b.handler((ChannelHandler)initializer);
            Channel channel = b.connect().syncUninterruptibly().channel();
            System.out.println("Connected to [" + HOST + ':' + PORT + ']');
            Http2SettingsHandler http2SettingsHandler = initializer.settingsHandler();
            http2SettingsHandler.awaitSettings(5L, TimeUnit.SECONDS);
            HttpResponseHandler responseHandler = initializer.responseHandler();
            int streamId = 3;
            HttpScheme scheme = SSL ? HttpScheme.HTTPS : HttpScheme.HTTP;
            AsciiString hostName = new AsciiString((CharSequence)(HOST + ':' + PORT));
            System.err.println("Sending request(s)...");
            if (URL != null) {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, URL);
                request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)hostName);
                request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
                request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
                request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
                responseHandler.put(streamId, channel.writeAndFlush((Object)request), channel.newPromise());
                streamId += 2;
            }
            if (URL2 != null) {
                request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, URL2, Unpooled.copiedBuffer((byte[])URL2DATA.getBytes(CharsetUtil.UTF_8)));
                request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)hostName);
                request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
                request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.GZIP);
                request.headers().add((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.DEFLATE);
                responseHandler.put(streamId, channel.writeAndFlush((Object)request), channel.newPromise());
                streamId += 2;
            }
            responseHandler.awaitResponses(5L, TimeUnit.SECONDS);
            System.out.println("Finished HTTP/2 request(s)");
            channel.close().syncUninterruptibly();
        }
        finally {
            workerGroup.shutdownGracefully();
        }
    }
}

