/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.tiles;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.example.http2.Http2ExampleUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class ImageCache {
    public static ImageCache INSTANCE = new ImageCache();
    private final Map<String, ByteBuf> imageBank = new HashMap<String, ByteBuf>(200);

    private ImageCache() {
        this.init();
    }

    public static String name(int x, int y) {
        return "tile-" + y + "-" + x + ".jpeg";
    }

    public ByteBuf image(int x, int y) {
        return this.imageBank.get(ImageCache.name(x, y));
    }

    private void init() {
        for (int y = 0; y < 10; ++y) {
            for (int x = 0; x < 20; ++x) {
                try {
                    String name = ImageCache.name(x, y);
                    ByteBuf fileBytes = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.unmodifiableBuffer((ByteBuf)Http2ExampleUtil.toByteBuf(this.getClass().getResourceAsStream(name))));
                    this.imageBank.put(name, fileBytes);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

