/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.socksproxy.DirectClientHandler;
import io.netty.example.socksproxy.RelayHandler;
import io.netty.example.socksproxy.SocksServerUtils;
import io.netty.handler.codec.socksx.SocksRequest;
import io.netty.handler.codec.socksx.v4.Socks4CmdRequest;
import io.netty.handler.codec.socksx.v4.Socks4CmdResponse;
import io.netty.handler.codec.socksx.v4.Socks4CmdStatus;
import io.netty.handler.codec.socksx.v5.Socks5CmdRequest;
import io.netty.handler.codec.socksx.v5.Socks5CmdResponse;
import io.netty.handler.codec.socksx.v5.Socks5CmdStatus;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;

@ChannelHandler.Sharable
public final class SocksServerConnectHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private final Bootstrap b = new Bootstrap();

    public void channelRead0(final ChannelHandlerContext ctx, SocksRequest message) throws Exception {
        if (message instanceof Socks4CmdRequest) {
            Socks4CmdRequest request = (Socks4CmdRequest)message;
            Promise promise = ctx.executor().newPromise();
            promise.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    final Channel outboundChannel = (Channel)future.getNow();
                    if (future.isSuccess()) {
                        ctx.channel().writeAndFlush((Object)new Socks4CmdResponse(Socks4CmdStatus.SUCCESS)).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                                ctx.pipeline().remove((ChannelHandler)SocksServerConnectHandler.this);
                                outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                                ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                            }
                        });
                    } else {
                        ctx.channel().writeAndFlush((Object)new Socks4CmdResponse(Socks4CmdStatus.REJECTED_OR_FAILED));
                        SocksServerUtils.closeOnFlush(ctx.channel());
                    }
                }
            });
            Channel inboundChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            this.b.connect(request.host(), request.port()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ctx.channel().writeAndFlush((Object)new Socks4CmdResponse(Socks4CmdStatus.REJECTED_OR_FAILED));
                        SocksServerUtils.closeOnFlush(ctx.channel());
                    }
                }
            });
        } else if (message instanceof Socks5CmdRequest) {
            final Socks5CmdRequest request = (Socks5CmdRequest)message;
            Promise promise = ctx.executor().newPromise();
            promise.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> future) throws Exception {
                    final Channel outboundChannel = (Channel)future.getNow();
                    if (future.isSuccess()) {
                        ctx.channel().writeAndFlush((Object)new Socks5CmdResponse(Socks5CmdStatus.SUCCESS, request.addressType())).addListener((GenericFutureListener)new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture channelFuture) {
                                ctx.pipeline().remove((ChannelHandler)SocksServerConnectHandler.this);
                                outboundChannel.pipeline().addLast(new ChannelHandler[]{new RelayHandler(ctx.channel())});
                                ctx.pipeline().addLast(new ChannelHandler[]{new RelayHandler(outboundChannel)});
                            }
                        });
                    } else {
                        ctx.channel().writeAndFlush((Object)new Socks5CmdResponse(Socks5CmdStatus.FAILURE, request.addressType()));
                        SocksServerUtils.closeOnFlush(ctx.channel());
                    }
                }
            });
            Channel inboundChannel = ctx.channel();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new DirectClientHandler((Promise<Channel>)promise));
            this.b.connect(request.host(), request.port()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        ctx.channel().writeAndFlush((Object)new Socks5CmdResponse(Socks5CmdStatus.FAILURE, request.addressType()));
                        SocksServerUtils.closeOnFlush(ctx.channel());
                    }
                }
            });
        } else {
            ctx.close();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        SocksServerUtils.closeOnFlush(ctx.channel());
    }
}

