/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.stomp.StompClient;
import io.netty.handler.codec.stomp.DefaultStompFrame;
import io.netty.handler.codec.stomp.StompCommand;
import io.netty.handler.codec.stomp.StompFrame;
import io.netty.handler.codec.stomp.StompHeaders;

public class StompClientHandler
extends SimpleChannelInboundHandler<StompFrame> {
    private ClientState state;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.state = ClientState.AUTHENTICATING;
        DefaultStompFrame connFrame = new DefaultStompFrame(StompCommand.CONNECT);
        connFrame.headers().set((CharSequence)StompHeaders.ACCEPT_VERSION, (Object)"1.2");
        connFrame.headers().set((CharSequence)StompHeaders.HOST, (Object)StompClient.HOST);
        connFrame.headers().set((CharSequence)StompHeaders.LOGIN, (Object)StompClient.LOGIN);
        connFrame.headers().set((CharSequence)StompHeaders.PASSCODE, (Object)StompClient.PASSCODE);
        ctx.writeAndFlush((Object)connFrame);
    }

    protected void channelRead0(ChannelHandlerContext ctx, StompFrame frame) throws Exception {
        String subscrReceiptId = "001";
        String disconReceiptId = "002";
        switch (frame.command()) {
            case CONNECTED: {
                DefaultStompFrame subscribeFrame = new DefaultStompFrame(StompCommand.SUBSCRIBE);
                subscribeFrame.headers().set((CharSequence)StompHeaders.DESTINATION, (Object)StompClient.TOPIC);
                subscribeFrame.headers().set((CharSequence)StompHeaders.RECEIPT, (Object)subscrReceiptId);
                subscribeFrame.headers().set((CharSequence)StompHeaders.ID, (Object)"1");
                System.out.println("connected, sending subscribe frame: " + subscribeFrame);
                this.state = ClientState.AUTHENTICATED;
                ctx.writeAndFlush((Object)subscribeFrame);
                break;
            }
            case RECEIPT: {
                String receiptHeader = frame.headers().get((CharSequence)StompHeaders.RECEIPT_ID);
                if (this.state == ClientState.AUTHENTICATED && receiptHeader.equals(subscrReceiptId)) {
                    DefaultStompFrame msgFrame = new DefaultStompFrame(StompCommand.SEND);
                    msgFrame.headers().set((CharSequence)StompHeaders.DESTINATION, (Object)StompClient.TOPIC);
                    msgFrame.content().writeBytes("some payload".getBytes());
                    System.out.println("subscribed, sending message frame: " + msgFrame);
                    this.state = ClientState.SUBSCRIBED;
                    ctx.writeAndFlush((Object)msgFrame);
                    break;
                }
                if (this.state == ClientState.DISCONNECTING && receiptHeader.equals(disconReceiptId)) {
                    System.out.println("disconnected");
                    ctx.close();
                    break;
                }
                throw new IllegalStateException("received: " + frame + ", while internal state is " + (Object)((Object)this.state));
            }
            case MESSAGE: {
                if (this.state != ClientState.SUBSCRIBED) break;
                System.out.println("received frame: " + frame);
                DefaultStompFrame disconnFrame = new DefaultStompFrame(StompCommand.DISCONNECT);
                disconnFrame.headers().set((CharSequence)StompHeaders.RECEIPT, (Object)disconReceiptId);
                System.out.println("sending disconnect frame: " + disconnFrame);
                this.state = ClientState.DISCONNECTING;
                ctx.writeAndFlush((Object)disconnFrame);
                break;
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    private static enum ClientState {
        AUTHENTICATING,
        AUTHENTICATED,
        SUBSCRIBED,
        DISCONNECTING;

    }
}

