/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.math.BigInteger;
import java.util.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactorialServerHandler
extends SimpleChannelInboundHandler<BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorialServerHandler.class.getName());
    private BigInteger lastMultiplier = new BigInteger("1");
    private BigInteger factorial = new BigInteger("1");

    public void channelRead0(ChannelHandlerContext ctx, BigInteger msg) throws Exception {
        this.lastMultiplier = msg;
        this.factorial = this.factorial.multiply(msg);
        ctx.writeAndFlush((Object)this.factorial);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        logger.info(new Formatter().format("Factorial of %,d is: %,d", this.lastMultiplier, this.factorial).toString());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

