/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.socksproxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.example.socksproxy.SocksServerUtils;
import io.netty.util.ReferenceCountUtil;

public final class RelayHandler
extends ChannelInboundHandlerAdapter {
    private static final String name = "RELAY_HANDLER";
    private final Channel relayChannel;

    public static String getName() {
        return name;
    }

    public RelayHandler(Channel relayChannel) {
        this.relayChannel = relayChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.relayChannel.isActive()) {
            this.relayChannel.writeAndFlush(msg);
        } else {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.relayChannel.isActive()) {
            SocksServerUtils.closeOnFlush(this.relayChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

