/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.spdy.client.HttpResponseClientHandler;
import io.netty.example.spdy.client.SpdyClientInitializer;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class SpdyClient {
    private final String host;
    private final int port;
    private final HttpResponseClientHandler httpResponseHandler;
    private Channel channel;
    private EventLoopGroup workerGroup;

    public SpdyClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.httpResponseHandler = new HttpResponseClientHandler();
    }

    public void start() {
        if (this.channel != null) {
            System.out.println("Already running!");
            return;
        }
        this.workerGroup = new NioEventLoopGroup();
        Bootstrap b = new Bootstrap();
        b.group(this.workerGroup);
        b.channel(NioSocketChannel.class);
        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        b.remoteAddress((SocketAddress)new InetSocketAddress(this.host, this.port));
        b.handler((ChannelHandler)new SpdyClientInitializer(this.httpResponseHandler));
        this.channel = b.connect().syncUninterruptibly().channel();
        System.out.println("Connected to [" + this.host + ':' + this.port + ']');
    }

    public void stop() {
        try {
            this.channel.close().syncUninterruptibly();
        }
        finally {
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
        }
    }

    public ChannelFuture send(HttpRequest request) {
        return this.channel.writeAndFlush((Object)request);
    }

    public HttpRequest get() {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "");
        request.headers().set("Host", (Object)this.host);
        request.headers().set("Accept-Encoding", (Object)"gzip");
        return request;
    }

    public BlockingQueue<ChannelFuture> httpResponseQueue() {
        return this.httpResponseHandler.queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8443;
        SpdyClient client = new SpdyClient("localhost", port);
        try {
            ChannelFuture responseFuture;
            client.start();
            ChannelFuture requestFuture = client.send(client.get()).sync();
            if (!requestFuture.isSuccess()) {
                requestFuture.cause().printStackTrace();
            }
            if (!(responseFuture = client.httpResponseQueue().poll(5L, TimeUnit.SECONDS)).isSuccess()) {
                responseFuture.cause().printStackTrace();
            }
            System.out.println("Finished SPDY HTTP GET");
        }
        finally {
            client.stop();
        }
    }
}

