/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;

public class HttpHelloWorldServerHandler
extends ChannelInboundHandlerAdapter {
    private static final byte[] CONTENT = new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])CONTENT));
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            if (!keepAlive) {
                ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                response.headers().set("Connection", (Object)"keep-alive");
                ctx.write((Object)response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

