/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.securechat.SecureChatServerHandler;
import io.netty.example.securechat.SecureChatSslContextFactory;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;

public class SecureChatServerInitializer
extends ChannelInitializer<SocketChannel> {
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SSLEngine engine = SecureChatSslContextFactory.getServerContext().createSSLEngine();
        engine.setUseClientMode(false);
        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        pipeline.addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter()));
        pipeline.addLast("decoder", (ChannelHandler)new StringDecoder());
        pipeline.addLast("encoder", (ChannelHandler)new StringEncoder());
        pipeline.addLast("handler", (ChannelHandler)new SecureChatServerHandler());
    }
}

