/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FactorialClientHandler
extends SimpleChannelInboundHandler<BigInteger> {
    private static final Logger logger = Logger.getLogger(FactorialClientHandler.class.getName());
    private ChannelHandlerContext ctx;
    private int receivedMessages;
    private final int count;
    final BlockingQueue<BigInteger> answer = new LinkedBlockingQueue<BigInteger>();
    private final ChannelFutureListener numberSender = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                FactorialClientHandler.this.sendNumbers();
            }
        }
    };

    public FactorialClientHandler(int count) {
        this.count = count;
    }

    public BigInteger getFactorial() {
        boolean interrupted = false;
        while (true) {
            try {
                BigInteger factorial = this.answer.take();
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
                return factorial;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.sendNumbers();
    }

    public void channelRead0(ChannelHandlerContext ctx, final BigInteger msg) {
        ++this.receivedMessages;
        if (this.receivedMessages == this.count) {
            ctx.channel().close().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    boolean offered = FactorialClientHandler.this.answer.offer(msg);
                    assert (offered);
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private void sendNumbers() {
        for (int i = 0; i < 4096 && i <= this.count; ++i) {
            ChannelFuture future = this.ctx.write((Object)i);
            if (this.count == i) {
                future.addListener((GenericFutureListener)this.numberSender);
            }
            ++i;
        }
        this.ctx.flush();
    }
}

