/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.MessageList;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class HttpHelloWorldServerHandler
extends SimpleChannelInboundHandler<Object> {
    private static final ByteBuf CONTENT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.US_ASCII));
    private MessageList<Object> out;

    protected void beginMessageReceived(ChannelHandlerContext ctx) {
        this.out = MessageList.newInstance();
    }

    protected void endMessageReceived(ChannelHandlerContext ctx) {
        ctx.write(this.out);
        this.out = null;
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                this.out.add((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, CONTENT.duplicate());
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            if (!keepAlive) {
                this.out.add((Object)response);
                ctx.write(this.out).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                this.out = MessageList.newInstance();
            } else {
                this.out.add((Object)response);
                response.headers().set("Connection", (Object)"keep-alive");
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

