/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.example.proxy.HexDumpProxyFrontendHandler;
import io.netty.util.concurrent.GenericFutureListener;

public class HexDumpProxyBackendHandler
extends ChannelInboundHandlerAdapter {
    private final Channel inboundChannel;

    public HexDumpProxyBackendHandler(Channel inboundChannel) {
        this.inboundChannel = inboundChannel;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void messageReceived(final ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        this.inboundChannel.write(msgs).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ctx.channel().read();
                } else {
                    future.channel().close();
                }
            }
        });
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HexDumpProxyFrontendHandler.closeOnFlush(this.inboundChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }
}

