/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecureChatServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = Logger.getLogger(SecureChatServerHandler.class.getName());
    static final ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);

    public void channelActive(final ChannelHandlerContext ctx) throws Exception {
        ((SslHandler)ctx.pipeline().get(SslHandler.class)).handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            public void operationComplete(Future<Channel> future) throws Exception {
                ctx.write((Object)("Welcome to " + InetAddress.getLocalHost().getHostName() + " secure chat service!\n"));
                ctx.write((Object)("Your session is protected by " + ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession().getCipherSuite() + " cipher suite.\n"));
                channels.add((Object)ctx.channel());
            }
        });
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> requests) throws Exception {
        MessageList msgs = requests.cast();
        for (int i = 0; i < msgs.size(); ++i) {
            String msg = (String)msgs.get(i);
            for (Channel c : channels) {
                if (c != ctx.channel()) {
                    c.write((Object)("[" + ctx.channel().remoteAddress() + "] " + msg + '\n'));
                    continue;
                }
                c.write((Object)("[you] " + msg + '\n'));
            }
            if (!"bye".equals(msg.toLowerCase())) continue;
            ctx.close();
        }
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

