/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;

public class HttpSnoopClientHandler
extends ChannelInboundHandlerAdapter {
    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        for (int i = 0; i < msgs.size(); ++i) {
            Object msg = msgs.get(i);
            if (msg instanceof HttpResponse) {
                HttpResponse response = (HttpResponse)msg;
                System.out.println("STATUS: " + response.getStatus());
                System.out.println("VERSION: " + response.getProtocolVersion());
                System.out.println();
                if (!response.headers().isEmpty()) {
                    for (String name : response.headers().names()) {
                        for (String value : response.headers().getAll(name)) {
                            System.out.println("HEADER: " + name + " = " + value);
                        }
                    }
                    System.out.println();
                }
                if (HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                    System.out.println("CHUNKED CONTENT {");
                } else {
                    System.out.println("CONTENT {");
                }
            }
            if (!(msg instanceof HttpContent)) continue;
            HttpContent content = (HttpContent)msg;
            System.out.print(content.content().toString(CharsetUtil.UTF_8));
            System.out.flush();
            if (!(content instanceof LastHttpContent)) continue;
            System.out.println("} END OF CONTENT");
        }
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

