/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.helloworld;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;

public class HttpHelloWorldServerHandler
extends ChannelInboundHandlerAdapter {
    private static final ByteBuf CONTENT = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"Hello World", (Charset)CharsetUtil.US_ASCII));

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList out = MessageList.newInstance();
        int size = msgs.size();
        for (int i = 0; i < size; ++i) {
            Object msg = msgs.get(i);
            if (!(msg instanceof HttpRequest)) continue;
            HttpRequest req = (HttpRequest)msg;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)req)) {
                out.add((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, CONTENT.duplicate());
            response.headers().set("Content-Type", (Object)"text/plain");
            response.headers().set("Content-Length", (Object)response.content().readableBytes());
            if (!keepAlive) {
                out.add((Object)response);
                ctx.write(out).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                out = MessageList.newInstance();
                continue;
            }
            out.add((Object)response);
            response.headers().set("Connection", (Object)"keep-alive");
        }
        ctx.write(out);
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

