/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.file;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.MessageList;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import javax.activation.MimetypesFileTypeMap;

public class HttpStaticFileServerHandler
extends ChannelInboundHandlerAdapter {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    private static final Pattern ALLOWED_FILE_NAME = Pattern.compile("[A-Za-z0-9][-_A-Za-z0-9\\.]*");

    public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
        MessageList requests = msgs.cast();
        for (int i = 0; i < requests.size(); ++i) {
            RandomAccessFile raf;
            long fileLastModifiedSeconds;
            SimpleDateFormat dateFormatter;
            Date ifModifiedSinceDate;
            long ifModifiedSinceDateSeconds;
            FullHttpRequest request = (FullHttpRequest)requests.get(i);
            if (!request.getDecoderResult().isSuccess()) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                continue;
            }
            if (request.getMethod() != HttpMethod.GET) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                continue;
            }
            String uri = request.getUri();
            String path = HttpStaticFileServerHandler.sanitizeUri(uri);
            if (path == null) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                continue;
            }
            File file = new File(path);
            if (file.isHidden() || !file.exists()) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                continue;
            }
            if (file.isDirectory()) {
                if (uri.endsWith("/")) {
                    HttpStaticFileServerHandler.sendListing(ctx, file);
                    continue;
                }
                HttpStaticFileServerHandler.sendRedirect(ctx, uri + '/');
                continue;
            }
            if (!file.isFile()) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                continue;
            }
            String ifModifiedSince = request.headers().get("If-Modified-Since");
            if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
                HttpStaticFileServerHandler.sendNotModified(ctx);
                continue;
            }
            try {
                raf = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException fnfe) {
                HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                continue;
            }
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            HttpStaticFileServerHandler.setContentTypeHeader((HttpResponse)response, file);
            HttpStaticFileServerHandler.setDateAndCacheHeaders((HttpResponse)response, file);
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) {
                response.headers().set("Connection", (Object)"keep-alive");
            }
            MessageList out = MessageList.newInstance();
            out.add((Object)response);
            out.add((Object)new ChunkedFile(raf, 0L, fileLength, 8192));
            out.add((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            ChannelFuture writeFuture = ctx.write(out);
            if (HttpHeaders.isKeepAlive((HttpMessage)request)) continue;
            writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        msgs.releaseAllAndRecycle();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            HttpStaticFileServerHandler.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private static String sanitizeUri(String uri) {
        try {
            uri = URLDecoder.decode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            try {
                uri = URLDecoder.decode(uri, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e1) {
                throw new Error();
            }
        }
        if (!uri.startsWith("/")) {
            return null;
        }
        if ((uri = uri.replace('/', File.separatorChar)).contains(File.separator + '.') || uri.contains('.' + File.separator) || uri.startsWith(".") || uri.endsWith(".") || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return System.getProperty("user.dir") + File.separator + uri;
    }

    private static void sendListing(ChannelHandlerContext ctx, File dir) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        StringBuilder buf = new StringBuilder();
        String dirPath = dir.getPath();
        buf.append("<!DOCTYPE html>\r\n");
        buf.append("<html><head><title>");
        buf.append("Listing of: ");
        buf.append(dirPath);
        buf.append("</title></head><body>\r\n");
        buf.append("<h3>Listing of: ");
        buf.append(dirPath);
        buf.append("</h3>\r\n");
        buf.append("<ul>");
        buf.append("<li><a href=\"../\">..</a></li>\r\n");
        for (File f : dir.listFiles()) {
            String name;
            if (f.isHidden() || !f.canRead() || !ALLOWED_FILE_NAME.matcher(name = f.getName()).matches()) continue;
            buf.append("<li><a href=\"");
            buf.append(name);
            buf.append("\">");
            buf.append(name);
            buf.append("</a></li>\r\n");
        }
        buf.append("</ul></body></html>\r\n");
        response.content().writeBytes(Unpooled.copiedBuffer((CharSequence)buf, (Charset)CharsetUtil.UTF_8));
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendRedirect(ChannelHandlerContext ctx, String newUri) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        response.headers().set("Location", (Object)newUri);
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + status.toString() + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set("Content-Type", (Object)"text/plain; charset=UTF-8");
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        HttpStaticFileServerHandler.setDateHeader((FullHttpResponse)response);
        ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set("Date", (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.headers().set("Expires", (Object)dateFormatter.format(time.getTime()));
        response.headers().set("Cache-Control", (Object)"private, max-age=60");
        response.headers().set("Last-Modified", (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
        response.headers().set("Content-Type", (Object)mimeTypesMap.getContentType(file.getPath()));
    }
}

