/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.oio.OioSctpChannel;
import io.netty.example.sctp.SctpEchoClientHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;

public class OioSctpEchoClient {
    private final String host;
    private final int port;
    private final int firstMessageSize;

    public OioSctpEchoClient(String host, int port, int firstMessageSize) {
        this.host = host;
        this.port = port;
        this.firstMessageSize = firstMessageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        OioEventLoopGroup group = new OioEventLoopGroup();
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(OioSctpChannel.class)).option((ChannelOption)SctpChannelOption.SCTP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SctpChannel>(){

                public void initChannel(SctpChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new SctpEchoClientHandler(OioSctpEchoClient.this.firstMessageSize)});
                }
            });
            ChannelFuture f = b.connect(this.host, this.port).sync();
            f.channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: " + OioSctpEchoClient.class.getSimpleName() + " <host> <port> [<first message size>]");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int firstMessageSize = args.length == 3 ? Integer.parseInt(args[2]) : 256;
        new OioSctpEchoClient(host, port, firstMessageSize).run();
    }
}

