/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.worldclock;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.example.worldclock.WorldClockProtocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class WorldClockClientHandler
extends ChannelInboundMessageHandlerAdapter<WorldClockProtocol.LocalTimes> {
    private static final Logger logger = Logger.getLogger(WorldClockClientHandler.class.getName());
    private static final Pattern DELIM = Pattern.compile("/");
    private volatile Channel channel;
    private final BlockingQueue<WorldClockProtocol.LocalTimes> answer = new LinkedBlockingQueue<WorldClockProtocol.LocalTimes>();

    public List<String> getLocalTimes(Collection<String> cities) {
        WorldClockProtocol.LocalTimes localTimes;
        WorldClockProtocol.Locations.Builder builder = WorldClockProtocol.Locations.newBuilder();
        for (String c : cities) {
            String[] components = DELIM.split(c);
            builder.addLocation(WorldClockProtocol.Location.newBuilder().setContinent(WorldClockProtocol.Continent.valueOf(components[0].toUpperCase())).setCity(components[1]).build());
        }
        this.channel.write((Object)builder.build());
        boolean interrupted = false;
        while (true) {
            try {
                localTimes = this.answer.take();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (WorldClockProtocol.LocalTime lt : localTimes.getLocalTimeList()) {
            result.add(new Formatter().format("%4d-%02d-%02d %02d:%02d:%02d %s", lt.getYear(), lt.getMonth(), lt.getDayOfMonth(), lt.getHour(), lt.getMinute(), lt.getSecond(), lt.getDayOfWeek().name()).toString());
        }
        return result;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
    }

    public void messageReceived(ChannelHandlerContext ctx, WorldClockProtocol.LocalTimes msg) throws Exception {
        this.answer.add(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", cause);
        ctx.close();
    }
}

