/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.logging.Level;
import java.util.logging.Logger;

@ChannelHandler.Sharable
public class ByteEchoServerHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger log = Logger.getLogger(ByteEchoServerHandler.class.getName());

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) {
        ByteBuf out = ctx.nextOutboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ChannelHandlerUtil.allocate((ChannelHandlerContext)ctx, (int)((Integer)ctx.channel().config().getOption(ChannelOption.SO_RCVBUF)));
    }
}

