/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.websocketx.client.WebSocketClientHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;

public class WebSocketClient {
    private final URI uri;

    public WebSocketClient(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            String protocol = this.uri.getScheme();
            if (!"ws".equals(protocol)) {
                throw new IllegalArgumentException("Unsupported protocol: " + protocol);
            }
            DefaultHttpHeaders customHeaders = new DefaultHttpHeaders();
            customHeaders.add("MyHeader", (Object)"MyValue");
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)this.uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)customHeaders));
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
                    pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(8192));
                    pipeline.addLast("ws-handler", (ChannelHandler)handler);
                }
            });
            System.out.println("WebSocket Client connecting");
            Channel ch = b.connect(this.uri.getHost(), this.uri.getPort()).sync().channel();
            handler.handshakeFuture().sync();
            System.out.println("WebSocket Client sending message");
            for (int i = 0; i < 10; ++i) {
                ch.write((Object)new TextWebSocketFrame("Message #" + i));
            }
            System.out.println("WebSocket Client sending ping");
            ch.write((Object)new PingWebSocketFrame(Unpooled.copiedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6})));
            System.out.println("WebSocket Client sending close");
            ch.write((Object)new CloseWebSocketFrame());
            ch.closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        URI uri = args.length > 0 ? new URI(args[0]) : new URI("ws://localhost:8080/websocket");
        new WebSocketClient(uri).run();
    }
}

