/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.bytes;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Meter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.udt.nio.NioUdtProvider;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ByteEchoClientHandler
extends ChannelInboundByteHandlerAdapter {
    private static final Logger log = Logger.getLogger(ByteEchoClientHandler.class.getName());
    private final ByteBuf message;
    final Meter meter = Metrics.newMeter(ByteEchoClientHandler.class, (String)"rate", (String)"bytes", (TimeUnit)TimeUnit.SECONDS);

    public ByteEchoClientHandler(int messageSize) {
        this.message = Unpooled.buffer((int)messageSize);
        for (int i = 0; i < this.message.capacity(); ++i) {
            this.message.writeByte((int)((byte)i));
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        log.info("ECHO active " + NioUdtProvider.socketUDT((Channel)ctx.channel()).toStringOptions());
        ctx.write((Object)this.message);
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) {
        this.meter.mark((long)in.readableBytes());
        ByteBuf out = ctx.nextOutboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.log(Level.WARNING, "close the connection when an exception is raised", cause);
        ctx.close();
    }

    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().directBuffer(((Integer)ctx.channel().config().getOption(ChannelOption.SO_RCVBUF)).intValue());
    }
}

