/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.worldclock;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.worldclock.WorldClockClientHandler;
import io.netty.example.worldclock.WorldClockClientInitializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class WorldClockClient {
    private final String host;
    private final int port;
    private final Collection<String> cities;
    private static final Pattern CITY_PATTERN = Pattern.compile("^[_A-Za-z]+/[_A-Za-z]+$");

    public WorldClockClient(String host, int port, Collection<String> cities) {
        this.host = host;
        this.port = port;
        this.cities = new ArrayList<String>();
        this.cities.addAll(cities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new WorldClockClientInitializer());
            Channel ch = b.connect(this.host, this.port).sync().channel();
            WorldClockClientHandler handler = (WorldClockClientHandler)ch.pipeline().get(WorldClockClientHandler.class);
            List<String> response = handler.getLocalTimes(this.cities);
            ch.close();
            Iterator<String> i1 = this.cities.iterator();
            Iterator<String> i2 = response.iterator();
            while (i1.hasNext()) {
                System.out.format("%28s: %s%n", i1.next(), i2.next());
            }
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            WorldClockClient.printUsage();
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        List<String> cities = WorldClockClient.parseCities(args, 2);
        if (cities == null) {
            return;
        }
        new WorldClockClient(host, port, cities).run();
    }

    private static void printUsage() {
        System.err.println("Usage: " + WorldClockClient.class.getSimpleName() + " <host> <port> <continent/city_name> ...");
        System.err.println("Example: " + WorldClockClient.class.getSimpleName() + " localhost 8080 America/New_York Asia/Seoul");
    }

    private static List<String> parseCities(String[] args, int offset) {
        ArrayList<String> cities = new ArrayList<String>();
        for (int i = offset; i < args.length; ++i) {
            if (!CITY_PATTERN.matcher(args[i]).matches()) {
                System.err.println("Syntax error: '" + args[i] + '\'');
                WorldClockClient.printUsage();
                return null;
            }
            cities.add(args[i].trim());
        }
        return cities;
    }
}

