/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.util.logging.Logger;

public class HttpUploadClientHandler
extends ChannelInboundMessageHandlerAdapter<Object> {
    private static final Logger logger = Logger.getLogger(HttpUploadClientHandler.class.getName());
    private boolean readingChunks;

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            logger.info("STATUS: " + response.getStatus());
            logger.info("VERSION: " + response.getProtocolVersion());
            if (!response.headers().isEmpty()) {
                for (String name : response.headers().names()) {
                    for (String value : response.headers().getAll(name)) {
                        logger.info("HEADER: " + name + " = " + value);
                    }
                }
            }
            if (response.getStatus().code() == 200 && HttpHeaders.isTransferEncodingChunked((HttpMessage)response)) {
                this.readingChunks = true;
                logger.info("CHUNKED CONTENT {");
            } else {
                logger.info("CONTENT {");
            }
        }
        if (msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            logger.info(chunk.data().toString(CharsetUtil.UTF_8));
            if (chunk instanceof LastHttpContent) {
                if (this.readingChunks) {
                    logger.info("} END OF CHUNKED CONTENT");
                } else {
                    logger.info("} END OF CONTENT");
                }
                this.readingChunks = false;
            } else {
                logger.info(chunk.data().toString(CharsetUtil.UTF_8));
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.channel().close();
    }
}

