/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.upload;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpUploadServerHandler
extends ChannelInboundMessageHandlerAdapter<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HttpUploadServerHandler.class);
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder responseContent = new StringBuilder();
    private static final HttpDataFactory factory = new DefaultHttpDataFactory(DefaultHttpDataFactory.MINSIZE);
    private HttpPostRequestDecoder decoder;

    public HttpUploadServerHandler() {
        super(new Class[0]);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        if (this.decoder != null) {
            this.decoder.cleanFiles();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.readingChunks) {
            HttpRequest request;
            URI uri;
            if (this.decoder != null) {
                this.decoder.cleanFiles();
                this.decoder = null;
            }
            if (!(uri = new URI((request = (this.request = (HttpRequest)msg)).getUri())).getPath().startsWith("/form")) {
                this.writeMenu(ctx);
                return;
            }
            this.responseContent.setLength(0);
            this.responseContent.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.responseContent.append("===================================\r\n");
            this.responseContent.append("VERSION: " + request.getProtocolVersion().getText() + "\r\n");
            this.responseContent.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            this.responseContent.append("\r\n\r\n");
            List headers = request.getHeaders();
            for (Map.Entry entry : headers) {
                this.responseContent.append("HEADER: " + (String)entry.getKey() + "=" + (String)entry.getValue() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            String value = request.getHeader("Cookie");
            Set cookies = value == null ? Collections.emptySet() : CookieDecoder.decode((String)value);
            for (Cookie cookie : cookies) {
                this.responseContent.append("COOKIE: " + cookie.toString() + "\r\n");
            }
            this.responseContent.append("\r\n\r\n");
            QueryStringDecoder decoderQuery = new QueryStringDecoder(request.getUri());
            Map uriAttributes = decoderQuery.getParameters();
            for (String key : uriAttributes.keySet()) {
                for (String valuen : (List)uriAttributes.get(key)) {
                    this.responseContent.append("URI: " + key + "=" + valuen + "\r\n");
                }
            }
            this.responseContent.append("\r\n\r\n");
            try {
                this.decoder = new HttpPostRequestDecoder(factory, request);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(ctx.channel());
                ctx.channel().close();
                return;
            }
            catch (HttpPostRequestDecoder.IncompatibleDataDecoderException e1) {
                this.responseContent.append(e1.getMessage());
                this.responseContent.append("\r\n\r\nEND OF GET CONTENT\r\n");
                this.writeResponse(ctx.channel());
                return;
            }
            this.responseContent.append("Is Chunked: " + request.getTransferEncoding().isMultiple() + "\r\n");
            this.responseContent.append("IsMultipart: " + this.decoder.isMultipart() + "\r\n");
            if (request.getTransferEncoding().isMultiple()) {
                this.responseContent.append("Chunks: ");
                this.readingChunks = true;
            } else {
                this.readHttpDataAllReceive(ctx.channel());
                this.responseContent.append("\r\n\r\nEND OF NOT CHUNKED CONTENT\r\n");
                this.writeResponse(ctx.channel());
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            try {
                this.decoder.offer(chunk);
            }
            catch (HttpPostRequestDecoder.ErrorDataDecoderException e1) {
                e1.printStackTrace();
                this.responseContent.append(e1.getMessage());
                this.writeResponse(ctx.channel());
                ctx.channel().close();
                return;
            }
            this.responseContent.append("o");
            this.readHttpDataChunkByChunk(ctx.channel());
            if (chunk.isLast()) {
                this.readHttpDataAllReceive(ctx.channel());
                this.writeResponse(ctx.channel());
                this.readingChunks = false;
            }
        }
    }

    private void readHttpDataAllReceive(Channel channel) {
        List datas = null;
        try {
            datas = this.decoder.getBodyHttpDatas();
        }
        catch (HttpPostRequestDecoder.NotEnoughDataDecoderException e1) {
            e1.printStackTrace();
            this.responseContent.append(e1.getMessage());
            this.writeResponse(channel);
            channel.close();
            return;
        }
        for (InterfaceHttpData data : datas) {
            this.writeHttpData(data);
        }
        this.responseContent.append("\r\n\r\nEND OF CONTENT AT FINAL END\r\n");
    }

    private void readHttpDataChunkByChunk(Channel channel) {
        try {
            while (this.decoder.hasNext()) {
                InterfaceHttpData data = this.decoder.next();
                if (data == null) continue;
                this.writeHttpData(data);
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException e1) {
            this.responseContent.append("\r\n\r\nEND OF CONTENT CHUNK BY CHUNK\r\n\r\n");
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.Attribute) {
            String value;
            Attribute attribute = (Attribute)data;
            try {
                value = attribute.getValue();
            }
            catch (IOException e1) {
                e1.printStackTrace();
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " Error while reading value: " + e1.getMessage() + "\r\n");
                return;
            }
            if (value.length() > 100) {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.getName() + " data too long\r\n");
            } else {
                this.responseContent.append("\r\nBODY Attribute: " + attribute.getHttpDataType().name() + ": " + attribute.toString() + "\r\n");
            }
        } else {
            this.responseContent.append("\r\nBODY FileUpload: " + data.getHttpDataType().name() + ": " + data.toString() + "\r\n");
            if (data.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                FileUpload fileUpload = (FileUpload)data;
                if (fileUpload.isCompleted()) {
                    if (fileUpload.length() < 10000L) {
                        this.responseContent.append("\tContent of file\r\n");
                        try {
                            this.responseContent.append(((FileUpload)data).getString(((FileUpload)data).getCharset()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        this.responseContent.append("\r\n");
                    } else {
                        this.responseContent.append("\tFile too long to be printed out:" + fileUpload.length() + "\r\n");
                    }
                } else {
                    this.responseContent.append("\tFile to be continued but should not!\r\n");
                }
            }
        }
    }

    private void writeResponse(Channel channel) {
        String value;
        Set cookies;
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)this.responseContent.toString(), (Charset)CharsetUtil.UTF_8);
        this.responseContent.setLength(0);
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(buf);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (!close) {
            response.setHeader("Content-Length", (Object)String.valueOf(buf.readableBytes()));
        }
        if (!(cookies = (value = this.request.getHeader("Cookie")) == null ? Collections.emptySet() : CookieDecoder.decode((String)value)).isEmpty()) {
            for (Cookie cookie : cookies) {
                response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((Cookie)cookie));
            }
        }
        ChannelFuture future = channel.write((Object)response);
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void writeMenu(ChannelHandlerContext ctx) {
        this.responseContent.setLength(0);
        this.responseContent.append("<html>");
        this.responseContent.append("<head>");
        this.responseContent.append("<title>Netty Test Form</title>\r\n");
        this.responseContent.append("</head>\r\n");
        this.responseContent.append("<body bgcolor=white><style>td{font-size: 12pt;}</style>");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr>");
        this.responseContent.append("<td>");
        this.responseContent.append("<h1>Netty Test Form</h1>");
        this.responseContent.append("Choose one FORM");
        this.responseContent.append("</td>");
        this.responseContent.append("</tr>");
        this.responseContent.append("</table>\r\n");
        this.responseContent.append("<CENTER>GET FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formget\" METHOD=\"GET\">");
        this.responseContent.append("<input type=hidden name=getform value=\"GET\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpost\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file (only file name will be transmitted): <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<CENTER>POST MULTIPART FORM<HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("<FORM ACTION=\"/formpostmultipart\" ENCTYPE=\"multipart/form-data\" METHOD=\"POST\">");
        this.responseContent.append("<input type=hidden name=getform value=\"POST\">");
        this.responseContent.append("<table border=\"0\">");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"info\" size=10></td></tr>");
        this.responseContent.append("<tr><td>Fill with value: <br> <input type=text name=\"secondinfo\" size=20>");
        this.responseContent.append("<tr><td>Fill with value: <br> <textarea name=\"thirdinfo\" cols=40 rows=10></textarea>");
        this.responseContent.append("<tr><td>Fill with file: <br> <input type=file name=\"myfile\">");
        this.responseContent.append("</td></tr>");
        this.responseContent.append("<tr><td><INPUT TYPE=\"submit\" NAME=\"Send\" VALUE=\"Send\"></INPUT></td>");
        this.responseContent.append("<td><INPUT TYPE=\"reset\" NAME=\"Clear\" VALUE=\"Clear\" ></INPUT></td></tr>");
        this.responseContent.append("</table></FORM>\r\n");
        this.responseContent.append("<CENTER><HR WIDTH=\"75%\" NOSHADE color=\"blue\"></CENTER>");
        this.responseContent.append("</body>");
        this.responseContent.append("</html>");
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)this.responseContent.toString(), (Charset)CharsetUtil.UTF_8);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(buf);
        response.setHeader("Content-Type", (Object)"text/html; charset=UTF-8");
        response.setHeader("Content-Length", (Object)String.valueOf(buf.readableBytes()));
        ctx.channel().write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(this.responseContent.toString(), cause);
        ctx.channel().close();
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

