/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.http.snoop.HttpSnoopClientInitializer;
import io.netty.handler.codec.http.ClientCookieEncoder;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.DefaultCookie;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;

public class HttpSnoopClient {
    private final URI uri;

    public HttpSnoopClient(URI uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        String scheme = this.uri.getScheme() == null ? "http" : this.uri.getScheme();
        String host = this.uri.getHost() == null ? "localhost" : this.uri.getHost();
        int port = this.uri.getPort();
        if (port == -1) {
            if (scheme.equalsIgnoreCase("http")) {
                port = 80;
            } else if (scheme.equalsIgnoreCase("https")) {
                port = 443;
            }
        }
        if (!scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
            System.err.println("Only HTTP(S) is supported.");
            return;
        }
        boolean ssl = scheme.equalsIgnoreCase("https");
        Bootstrap b = new Bootstrap();
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).handler((ChannelHandler)new HttpSnoopClientInitializer(ssl))).remoteAddress((SocketAddress)new InetSocketAddress(host, port));
            Channel ch = b.connect().sync().channel();
            DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.uri.getRawPath());
            request.setHeader("Host", (Object)host);
            request.setHeader("Connection", (Object)"close");
            request.setHeader("Accept-Encoding", (Object)"gzip");
            request.setHeader("Cookie", (Object)ClientCookieEncoder.encode((Cookie[])new Cookie[]{new DefaultCookie("my-cookie", "foo"), new DefaultCookie("another-cookie", "bar")}));
            ch.write((Object)request);
            ch.closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Usage: " + HttpSnoopClient.class.getSimpleName() + " <URL>");
            return;
        }
        URI uri = new URI(args[0]);
        new HttpSnoopClient(uri).run();
    }
}

