/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.ServerCookieEncoder;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpSnoopServerHandler
extends ChannelInboundMessageHandlerAdapter<Object> {
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder buf = new StringBuilder();

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.readingChunks) {
            QueryStringDecoder queryStringDecoder;
            Map params;
            this.request = (HttpRequest)msg;
            HttpRequest request = this.request;
            if (HttpHeaders.is100ContinueExpected((HttpMessage)request)) {
                HttpSnoopServerHandler.send100Continue(ctx);
            }
            this.buf.setLength(0);
            this.buf.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.buf.append("===================================\r\n");
            this.buf.append("VERSION: ").append(request.getProtocolVersion()).append("\r\n");
            this.buf.append("HOSTNAME: ").append(HttpHeaders.getHost((HttpMessage)request, (String)"unknown")).append("\r\n");
            this.buf.append("REQUEST_URI: ").append(request.getUri()).append("\r\n\r\n");
            List headers = request.getHeaders();
            if (!headers.isEmpty()) {
                for (Map.Entry h : request.getHeaders()) {
                    String key = (String)h.getKey();
                    String string = (String)h.getValue();
                    this.buf.append("HEADER: ").append(key).append(" = ").append(string).append("\r\n");
                }
                this.buf.append("\r\n");
            }
            if (!(params = (queryStringDecoder = new QueryStringDecoder(request.getUri())).getParameters()).isEmpty()) {
                for (Map.Entry entry : params.entrySet()) {
                    String key = (String)entry.getKey();
                    List vals = (List)entry.getValue();
                    for (String val : vals) {
                        this.buf.append("PARAM: ").append(key).append(" = ").append(val).append("\r\n");
                    }
                }
                this.buf.append("\r\n");
            }
            if (request.getTransferEncoding().isMultiple()) {
                this.readingChunks = true;
            } else {
                ByteBuf content = request.getContent();
                if (content.readable()) {
                    this.buf.append("CONTENT: ");
                    this.buf.append(content.toString(CharsetUtil.UTF_8));
                    this.buf.append("\r\n");
                }
                HttpSnoopServerHandler.appendDecoderResult(this.buf, (HttpObject)request);
                this.writeResponse(ctx, (HttpObject)request);
            }
        } else {
            HttpChunk chunk = (HttpChunk)msg;
            if (chunk.isLast()) {
                this.readingChunks = false;
                this.buf.append("END OF CONTENT\r\n");
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                if (!trailer.getHeaderNames().isEmpty()) {
                    this.buf.append("\r\n");
                    for (String name : trailer.getHeaderNames()) {
                        for (String string : trailer.getHeaders(name)) {
                            this.buf.append("TRAILING HEADER: ");
                            this.buf.append(name).append(" = ").append(string).append("\r\n");
                        }
                    }
                    this.buf.append("\r\n");
                }
                HttpSnoopServerHandler.appendDecoderResult(this.buf, (HttpObject)chunk);
                this.writeResponse(ctx, (HttpObject)chunk);
            } else {
                this.buf.append("CHUNK: ");
                this.buf.append(chunk.getContent().toString(CharsetUtil.UTF_8)).append("\r\n");
                HttpSnoopServerHandler.appendDecoderResult(this.buf, (HttpObject)chunk);
            }
        }
    }

    private static void appendDecoderResult(StringBuilder buf, HttpObject o) {
        DecoderResult result = o.getDecoderResult();
        if (result.isSuccess()) {
            return;
        }
        buf.append(".. WITH A ");
        if (result.isPartialFailure()) {
            buf.append("PARTIAL ");
        }
        buf.append("DECODER FAILURE: ");
        buf.append(result.cause());
        buf.append("\r\n");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpObject currentObj) {
        String cookieString;
        boolean keepAlive = HttpHeaders.isKeepAlive((HttpMessage)this.request);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, currentObj.getDecoderResult().isSuccess() ? HttpResponseStatus.OK : HttpResponseStatus.BAD_REQUEST);
        response.setContent(Unpooled.copiedBuffer((CharSequence)this.buf.toString(), (Charset)CharsetUtil.UTF_8));
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        if (keepAlive) {
            response.setHeader("Content-Length", (Object)response.getContent().readableBytes());
            response.setHeader("Connection", (Object)"keep-alive");
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null) {
            Set cookies = CookieDecoder.decode((String)cookieString);
            if (!cookies.isEmpty()) {
                for (Cookie cookie : cookies) {
                    response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((Cookie)cookie));
                }
            }
        } else {
            response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((String)"key1", (String)"value1"));
            response.addHeader("Set-Cookie", (Object)ServerCookieEncoder.encode((String)"key2", (String)"value2"));
        }
        ChannelFuture future = ctx.write((Object)response);
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static void send100Continue(ChannelHandlerContext ctx) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        ctx.write((Object)response);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

