/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.securechat.SecureChatClientInitializer;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class SecureChatClient {
    private final String host;
    private final int port;

    public SecureChatClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            String line;
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)new NioEventLoopGroup())).channel(NioSocketChannel.class)).remoteAddress(this.host, this.port).handler((ChannelHandler)new SecureChatClientInitializer());
            Channel ch = b.connect().sync().channel();
            ChannelFuture lastWriteFuture = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                lastWriteFuture = ch.write((Object)(line + "\r\n"));
                if (!line.toLowerCase().equals("bye")) continue;
                ch.closeFuture().sync();
                break;
            }
            if (lastWriteFuture != null) {
                lastWriteFuture.sync();
            }
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + SecureChatClient.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        new SecureChatClient(host, port).run();
    }
}

