/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.uptime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.uptime.UptimeClientHandler;
import io.netty.handler.timeout.IdleStateHandler;

public class UptimeClient {
    static final int RECONNECT_DELAY = 5;
    private static final int READ_TIMEOUT = 10;
    private final String host;
    private final int port;
    private final UptimeClientHandler handler = new UptimeClientHandler(this);

    public UptimeClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void run() {
        this.configureBootstrap(new Bootstrap()).connect();
    }

    private Bootstrap configureBootstrap(Bootstrap b) {
        return this.configureBootstrap(b, (EventLoopGroup)new NioEventLoopGroup());
    }

    Bootstrap configureBootstrap(Bootstrap b, EventLoopGroup g) {
        b.group(g).channel((Channel)new NioSocketChannel()).remoteAddress(this.host, this.port).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(10, 0, 0), UptimeClient.this.handler});
            }
        });
        return b;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + UptimeClient.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        new UptimeClient(host, port).run();
    }
}

