/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.proxy;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.proxy.HexDumpProxyBackendHandler;

public class HexDumpProxyFrontendHandler
extends ChannelInboundByteHandlerAdapter {
    private final String remoteHost;
    private final int remotePort;
    private volatile Channel outboundChannel;

    public HexDumpProxyFrontendHandler(String remoteHost, int remotePort) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        b.group((EventLoopGroup)inboundChannel.eventLoop()).channel((Channel)new NioSocketChannel()).remoteAddress(this.remoteHost, this.remotePort).handler((ChannelHandler)new HexDumpProxyBackendHandler(inboundChannel));
        ChannelFuture f = b.connect();
        this.outboundChannel = f.channel();
        f.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    inboundChannel.close();
                }
            }
        });
    }

    public void inboundBufferUpdated(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        ByteBuf out = this.outboundChannel.outboundByteBuffer();
        out.discardReadBytes();
        out.writeBytes(in);
        in.clear();
        if (this.outboundChannel.isActive()) {
            this.outboundChannel.flush();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.outboundChannel != null) {
            HexDumpProxyFrontendHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        HexDumpProxyFrontendHandler.closeOnFlush(ctx.channel());
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.flush().addListener(ChannelFutureListener.CLOSE);
        }
    }
}

