/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.portunification;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.portunification.PortUnificationServerHandler;

public class PortUnificationServer {
    private final int port;

    public PortUnificationServer(int port) {
        this.port = port;
    }

    public void run() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        try {
            b.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel((ServerChannel)new NioServerSocketChannel()).localAddress(this.port).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new PortUnificationServerHandler()});
                }
            });
            b.bind().sync().channel().closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new PortUnificationServer(port).run();
    }
}

