/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.websocketx.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.http.websocketx.server.WebSocketServerInitializer;

public class WebSocketServer {
    private final int port;

    public WebSocketServer(int port) {
        this.port = port;
    }

    public void run() throws Exception {
        ServerBootstrap b = new ServerBootstrap();
        try {
            b.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel((ServerChannel)new NioServerSocketChannel()).localAddress(this.port).childHandler((ChannelHandler)new WebSocketServerInitializer());
            Channel ch = b.bind().sync().channel();
            System.out.println("Web socket server started at port " + this.port + '.');
            System.out.println("Open your browser and navigate to http://localhost:" + this.port + '/');
            ch.closeFuture().sync();
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new WebSocketServer(port).run();
    }
}

