/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.qotm;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioEventLoop;
import io.netty.example.qotm.QuoteOfTheMomentClientHandler;
import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.Charset;

public class QuoteOfTheMomentClient {
    private final int port;

    public QuoteOfTheMomentClient(int port) {
        this.port = port;
    }

    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            b.eventLoop((EventLoop)new NioEventLoop()).channel((Channel)new NioDatagramChannel()).localAddress((SocketAddress)new InetSocketAddress(0)).option(ChannelOption.SO_BROADCAST, (Object)true).handler((ChannelHandler)new QuoteOfTheMomentClientHandler());
            Channel ch = b.bind().sync().channel();
            ch.write((Object)new DatagramPacket(Unpooled.copiedBuffer((CharSequence)"QOTM?", (Charset)CharsetUtil.UTF_8), new InetSocketAddress("255.255.255.255", this.port)));
            if (!ch.closeFuture().await(5000L)) {
                System.err.println("QOTM request timed out.");
            }
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new QuoteOfTheMomentClient(port).run();
    }
}

