/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.localtime;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.nio.NioEventLoop;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.localtime.LocalTimeClientHandler;
import io.netty.example.localtime.LocalTimeClientInitializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LocalTimeClient {
    private final String host;
    private final int port;
    private final Collection<String> cities;

    public LocalTimeClient(String host, int port, Collection<String> cities) {
        this.host = host;
        this.port = port;
        this.cities = new ArrayList<String>();
        this.cities.addAll(cities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Bootstrap b = new Bootstrap();
        try {
            b.eventLoop((EventLoop)new NioEventLoop()).channel((Channel)new NioSocketChannel()).remoteAddress(this.host, this.port).handler((ChannelHandler)new LocalTimeClientInitializer());
            Channel ch = b.connect().sync().channel();
            LocalTimeClientHandler handler = (LocalTimeClientHandler)ch.pipeline().get(LocalTimeClientHandler.class);
            List<String> response = handler.getLocalTimes(this.cities);
            ch.close();
            Iterator<String> i1 = this.cities.iterator();
            Iterator<String> i2 = response.iterator();
            while (i1.hasNext()) {
                System.out.format("%28s: %s%n", i1.next(), i2.next());
            }
        }
        finally {
            b.shutdown();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            LocalTimeClient.printUsage();
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        List<String> cities = LocalTimeClient.parseCities(args, 2);
        if (cities == null) {
            return;
        }
        new LocalTimeClient(host, port, cities).run();
    }

    private static void printUsage() {
        System.err.println("Usage: " + LocalTimeClient.class.getSimpleName() + " <host> <port> <continent/city_name> ...");
        System.err.println("Example: " + LocalTimeClient.class.getSimpleName() + " localhost 8080 America/New_York Asia/Seoul");
    }

    private static List<String> parseCities(String[] args, int offset) {
        ArrayList<String> cities = new ArrayList<String>();
        for (int i = offset; i < args.length; ++i) {
            if (!args[i].matches("^[_A-Za-z]+/[_A-Za-z]+$")) {
                System.err.println("Syntax error: '" + args[i] + "'");
                LocalTimeClient.printUsage();
                return null;
            }
            cities.add(args[i].trim());
        }
        return cities;
    }
}

