/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.SystemPropertyUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SystemPropertyUtilTest {
    @Before
    public void clearSystemPropertyBeforeEach() {
        System.clearProperty("key");
    }

    @Test(expected=NullPointerException.class)
    public void testGetWithKeyNull() {
        SystemPropertyUtil.get(null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetWithKeyEmpty() {
        SystemPropertyUtil.get((String)"", null);
    }

    @Test
    public void testGetDefaultValueWithPropertyNull() {
        Assert.assertEquals((Object)"default", (Object)SystemPropertyUtil.get((String)"key", (String)"default"));
    }

    @Test
    public void testGetPropertyValue() {
        System.setProperty("key", "value");
        Assert.assertEquals((Object)"value", (Object)SystemPropertyUtil.get((String)"key"));
    }

    @Test
    public void testGetBooleanDefaultValueWithPropertyNull() {
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void testGetBooleanDefaultValueWithEmptyString() {
        System.setProperty("key", "");
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void testGetBooleanWithTrueValue() {
        System.setProperty("key", "true");
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "yes");
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "1");
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
    }

    @Test
    public void testGetBooleanWithFalseValue() {
        System.setProperty("key", "false");
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        System.setProperty("key", "no");
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
        System.setProperty("key", "0");
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
    }

    @Test
    public void testGetBooleanDefaultValueWithWrongValue() {
        System.setProperty("key", "abc");
        Assert.assertTrue((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)true));
        System.setProperty("key", "123");
        Assert.assertFalse((boolean)SystemPropertyUtil.getBoolean((String)"key", (boolean)false));
    }

    @Test
    public void getIntDefaultValueWithPropertyNull() {
        Assert.assertEquals((long)1L, (long)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getIntWithPropertValueIsInt() {
        System.setProperty("key", "123");
        Assert.assertEquals((long)123L, (long)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getIntDefaultValueWithPropertValueIsNotInt() {
        System.setProperty("key", "NotInt");
        Assert.assertEquals((long)1L, (long)SystemPropertyUtil.getInt((String)"key", (int)1));
    }

    @Test
    public void getLongDefaultValueWithPropertyNull() {
        Assert.assertEquals((long)1L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }

    @Test
    public void getLongWithPropertValueIsLong() {
        System.setProperty("key", "123");
        Assert.assertEquals((long)123L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }

    @Test
    public void getLongDefaultValueWithPropertValueIsNotLong() {
        System.setProperty("key", "NotInt");
        Assert.assertEquals((long)1L, (long)SystemPropertyUtil.getLong((String)"key", (long)1L));
    }
}

