/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PlatformDependentTest {
    private static final Random r = new Random();

    @Test
    public void testEqualsConsistentTime() {
        PlatformDependentTest.testEquals(new EqualityChecker(){

            @Override
            public boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
                return PlatformDependent.equalsConstantTime((byte[])bytes1, (int)startPos1, (byte[])bytes2, (int)startPos2, (int)length) != 0;
            }
        });
    }

    @Test
    public void testEquals() {
        PlatformDependentTest.testEquals(new EqualityChecker(){

            @Override
            public boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
                return PlatformDependent.equals((byte[])bytes1, (int)startPos1, (byte[])bytes2, (int)startPos2, (int)length);
            }
        });
    }

    @Test
    public void testIsZero() {
        byte[] bytes = new byte[100];
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)0, (int)0));
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)0, (int)-1));
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)0, (int)100));
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)10, (int)90));
        bytes[10] = 1;
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)0, (int)10));
        Assert.assertFalse((boolean)PlatformDependent.isZero((byte[])bytes, (int)0, (int)11));
        Assert.assertFalse((boolean)PlatformDependent.isZero((byte[])bytes, (int)10, (int)1));
        Assert.assertTrue((boolean)PlatformDependent.isZero((byte[])bytes, (int)11, (int)89));
    }

    private static void testEquals(EqualityChecker equalsChecker) {
        int i;
        byte[] bytes1 = new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        byte[] bytes2 = new byte[]{72, 101, 108, 108, 111, 32, 87, 111, 114, 108, 100};
        Assert.assertNotSame((Object)bytes1, (Object)bytes2);
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 2, bytes2, 2, bytes1.length - 2));
        bytes1 = new byte[]{1, 2, 3, 4, 5, 6};
        bytes2 = new byte[]{1, 2, 3, 4, 5, 6, 7};
        Assert.assertNotSame((Object)bytes1, (Object)bytes2);
        Assert.assertFalse((boolean)equalsChecker.equals(bytes1, 0, bytes2, 1, bytes1.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes2, 0, bytes1, 0, bytes1.length));
        bytes1 = new byte[]{1, 2, 3, 4};
        bytes2 = new byte[]{1, 2, 3, 5};
        Assert.assertFalse((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, 3));
        bytes1 = new byte[]{1, 2, 3, 4};
        bytes2 = new byte[]{1, 3, 3, 4};
        Assert.assertFalse((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 2, bytes2, 2, bytes1.length - 2));
        bytes1 = new byte[]{};
        bytes2 = new byte[]{};
        Assert.assertNotSame((Object)bytes1, (Object)bytes2);
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, 0));
        bytes1 = new byte[100];
        bytes2 = new byte[100];
        for (i = 0; i < 100; ++i) {
            bytes1[i] = (byte)i;
            bytes2[i] = (byte)i;
        }
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        bytes1[50] = 0;
        Assert.assertFalse((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 51, bytes2, 51, bytes1.length - 51));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, 50));
        bytes1 = new byte[]{1, 2, 3, 4, 5};
        bytes2 = new byte[]{3, 4, 5};
        Assert.assertFalse((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes2.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 2, bytes2, 0, bytes2.length));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes2, 0, bytes1, 2, bytes2.length));
        for (i = 0; i < 1000; ++i) {
            bytes1 = new byte[i];
            r.nextBytes(bytes1);
            bytes2 = (byte[])bytes1.clone();
            Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, bytes1.length));
        }
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, 0));
        Assert.assertTrue((boolean)equalsChecker.equals(bytes1, 0, bytes2, 0, -1));
    }

    private static char randomCharInByteRange() {
        return (char)r.nextInt(256);
    }

    @Test
    public void testHashCodeAscii() {
        for (int i = 0; i < 1000; ++i) {
            byte[] bytes = new byte[i];
            char[] bytesChar = new char[i];
            for (int j = 0; j < bytesChar.length; ++j) {
                bytesChar[j] = PlatformDependentTest.randomCharInByteRange();
                bytes[j] = (byte)(bytesChar[j] & 0xFF);
            }
            String string = new String(bytesChar);
            Assert.assertEquals((String)("length=" + i), (long)PlatformDependent.hashCodeAsciiSafe((byte[])bytes, (int)0, (int)bytes.length), (long)PlatformDependent.hashCodeAscii((byte[])bytes, (int)0, (int)bytes.length));
            Assert.assertEquals((String)("length=" + i), (long)PlatformDependent.hashCodeAscii((byte[])bytes, (int)0, (int)bytes.length), (long)PlatformDependent.hashCodeAscii((CharSequence)string));
        }
    }

    @Test
    public void testAllocateWithCapacity0() {
        Assume.assumeTrue((boolean)PlatformDependent.hasDirectBufferNoCleanerConstructor());
        ByteBuffer buffer = PlatformDependent.allocateDirectNoCleaner((int)0);
        Assert.assertNotEquals((long)0L, (long)PlatformDependent.directBufferAddress((ByteBuffer)buffer));
        Assert.assertEquals((long)0L, (long)buffer.capacity());
        PlatformDependent.freeDirectNoCleaner((ByteBuffer)buffer);
    }

    private static interface EqualityChecker {
        public boolean equals(byte[] var1, int var2, byte[] var3, int var4, int var5);
    }
}

