/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent0;
import java.nio.ByteBuffer;
import java.security.Permission;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PlatformDependent0Test {
    @BeforeClass
    public static void assumeUnsafe() {
        Assume.assumeTrue((boolean)PlatformDependent0.hasUnsafe());
        Assume.assumeTrue((boolean)PlatformDependent0.hasDirectBufferNoCleanerConstructor());
    }

    @Test
    public void testNewDirectBufferNegativeMemoryAddress() {
        PlatformDependent0Test.testNewDirectBufferMemoryAddress(-1L);
    }

    @Test
    public void testNewDirectBufferNonNegativeMemoryAddress() {
        PlatformDependent0Test.testNewDirectBufferMemoryAddress(10L);
    }

    @Test
    public void testNewDirectBufferZeroMemoryAddress() {
        PlatformDependent0.newDirectBuffer((long)0L, (int)10);
    }

    private static void testNewDirectBufferMemoryAddress(long address) {
        Assume.assumeTrue((boolean)PlatformDependent0.hasDirectBufferNoCleanerConstructor());
        int capacity = 10;
        ByteBuffer buffer = PlatformDependent0.newDirectBuffer((long)address, (int)capacity);
        Assert.assertEquals((long)address, (long)PlatformDependent0.directBufferAddress((ByteBuffer)buffer));
        Assert.assertEquals((long)capacity, (long)buffer.capacity());
    }

    @Test
    public void testMajorVersionFromJavaSpecificationVersion() {
        SecurityManager current = System.getSecurityManager();
        try {
            System.setSecurityManager(new SecurityManager(){

                @Override
                public void checkPropertyAccess(String key) {
                    if (key.equals("java.specification.version")) {
                        throw new SecurityException(key);
                    }
                }

                @Override
                public void checkPermission(Permission perm) {
                }
            });
            Assert.assertEquals((long)6L, (long)PlatformDependent0.majorVersionFromJavaSpecificationVersion());
        }
        finally {
            System.setSecurityManager(current);
        }
    }

    @Test
    public void testMajorVersion() {
        Assert.assertEquals((long)6L, (long)PlatformDependent0.majorVersion((String)"1.6"));
        Assert.assertEquals((long)7L, (long)PlatformDependent0.majorVersion((String)"1.7"));
        Assert.assertEquals((long)8L, (long)PlatformDependent0.majorVersion((String)"1.8"));
        Assert.assertEquals((long)8L, (long)PlatformDependent0.majorVersion((String)"8"));
        Assert.assertEquals((long)9L, (long)PlatformDependent0.majorVersion((String)"1.9"));
        Assert.assertEquals((long)9L, (long)PlatformDependent0.majorVersion((String)"9"));
    }
}

