/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class PromiseNotifierTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testNullPromisesArray() {
        this.expectedException.expect(NullPointerException.class);
        new PromiseNotifier((Promise[])null);
    }

    @Test
    public void testNullPromiseInArray() {
        this.expectedException.expect(IllegalArgumentException.class);
        new PromiseNotifier(new Promise[]{null});
    }

    @Test
    public void testListenerSuccess() throws Exception {
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        PromiseNotifier notifier = new PromiseNotifier(new Promise[]{p1, p2});
        Future future = (Future)Mockito.mock(Future.class);
        Mockito.when((Object)future.isSuccess()).thenReturn((Object)true);
        Mockito.when((Object)future.get()).thenReturn(null);
        Mockito.when((Object)p1.trySuccess(null)).thenReturn((Object)true);
        Mockito.when((Object)p2.trySuccess(null)).thenReturn((Object)true);
        notifier.operationComplete(future);
        ((Promise)Mockito.verify((Object)p1)).trySuccess(null);
        ((Promise)Mockito.verify((Object)p2)).trySuccess(null);
    }

    @Test
    public void testListenerFailure() throws Exception {
        Promise p1 = (Promise)Mockito.mock(Promise.class);
        Promise p2 = (Promise)Mockito.mock(Promise.class);
        PromiseNotifier notifier = new PromiseNotifier(new Promise[]{p1, p2});
        Future future = (Future)Mockito.mock(Future.class);
        Throwable t = (Throwable)Mockito.mock(Throwable.class);
        Mockito.when((Object)future.isSuccess()).thenReturn((Object)false);
        Mockito.when((Object)future.isCancelled()).thenReturn((Object)false);
        Mockito.when((Object)future.cause()).thenReturn((Object)t);
        Mockito.when((Object)p1.tryFailure(t)).thenReturn((Object)true);
        Mockito.when((Object)p2.tryFailure(t)).thenReturn((Object)true);
        notifier.operationComplete(future);
        ((Promise)Mockito.verify((Object)p1)).tryFailure(t);
        ((Promise)Mockito.verify((Object)p2)).tryFailure(t);
    }
}

