/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import org.junit.Assert;
import org.junit.Test;

public class DomainWildcardMappingBuilderTest {
    @Test(expected=NullPointerException.class)
    public void testNullDefaultValue() {
        new DomainWildcardMappingBuilder(null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullDomainNamePatternsAreForbidden() {
        new DomainWildcardMappingBuilder((Object)"NotFound").add(null, (Object)"Some value");
    }

    @Test(expected=NullPointerException.class)
    public void testNullValuesAreForbidden() {
        new DomainWildcardMappingBuilder((Object)"NotFound").add("Some key", null);
    }

    @Test
    public void testDefaultValue() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"not-existing"));
    }

    @Test
    public void testStrictEquality() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build();
        Assert.assertEquals((Object)"Netty", (Object)mapping.map((Object)"netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)mapping.map((Object)"downloads.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"x.y.z.netty.io"));
    }

    @Test
    public void testWildcardMatchesNotAnyPrefix() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").build();
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"netty.io"));
        Assert.assertEquals((Object)"Netty", (Object)mapping.map((Object)"downloads.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"x.y.z.netty.io"));
        Assert.assertEquals((Object)"NotFound", (Object)mapping.map((Object)"netty.io.x"));
    }

    @Test
    public void testExactMatchWins() {
        Assert.assertEquals((Object)"Netty-Downloads", (Object)new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Downloads").build().map((Object)"downloads.netty.io"));
        Assert.assertEquals((Object)"Netty-Downloads", (Object)new DomainWildcardMappingBuilder((Object)"NotFound").add("downloads.netty.io", (Object)"Netty-Downloads").add("*.netty.io", (Object)"Netty").build().map((Object)"downloads.netty.io"));
    }

    @Test
    public void testToString() {
        Mapping mapping = new DomainWildcardMappingBuilder((Object)"NotFound").add("*.netty.io", (Object)"Netty").add("downloads.netty.io", (Object)"Netty-Download").build();
        Assert.assertEquals((Object)"ImmutableDomainWildcardMapping(default: NotFound, map: {*.netty.io=Netty, downloads.netty.io=Netty-Download})", (Object)mapping.toString());
    }
}

