/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class StringUtilTest {
    @Test
    public void ensureNewlineExists() {
        Assert.assertNotNull((Object)StringUtil.NEWLINE);
    }

    @Test
    public void testToHexString() {
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{0}), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{0, 0}), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])new byte[]{1, 0}), (Matcher)CoreMatchers.is((Object)"100"));
        MatcherAssert.assertThat((Object)StringUtil.toHexString((byte[])EmptyArrays.EMPTY_BYTES), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void testToHexStringPadded() {
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{0}), (Matcher)CoreMatchers.is((Object)"00"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{1}), (Matcher)CoreMatchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{0, 0}), (Matcher)CoreMatchers.is((Object)"0000"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])new byte[]{1, 0}), (Matcher)CoreMatchers.is((Object)"0100"));
        MatcherAssert.assertThat((Object)StringUtil.toHexStringPadded((byte[])EmptyArrays.EMPTY_BYTES), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void splitSimple() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo:bar".split(":"));
    }

    @Test
    public void splitWithTrailingDelimiter() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo,bar,".split(","));
    }

    @Test
    public void splitWithTrailingDelimiters() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo!bar!!".split("!"));
    }

    @Test
    public void splitWithTrailingDelimitersDot() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo.bar..".split("\\."));
    }

    @Test
    public void splitWithTrailingDelimitersEq() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo=bar==".split("="));
    }

    @Test
    public void splitWithTrailingDelimitersSpace() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar"}, (Object[])"foo bar  ".split(" "));
    }

    @Test
    public void splitWithConsecutiveDelimiters() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "", "bar"}, (Object[])"foo$$bar".split("\\$"));
    }

    @Test
    public void splitWithDelimiterAtBeginning() {
        Assert.assertArrayEquals((Object[])new String[]{"", "foo", "bar"}, (Object[])"#foo#bar".split("#"));
    }

    @Test
    public void splitMaxPart() {
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar:bar2"}, (Object[])"foo:bar:bar2".split(":", 2));
        Assert.assertArrayEquals((Object[])new String[]{"foo", "bar", "bar2"}, (Object[])"foo:bar:bar2".split(":", 3));
    }

    @Test
    public void substringAfterTest() {
        Assert.assertEquals((Object)"bar:bar2", (Object)StringUtil.substringAfter((String)"foo:bar:bar2", (char)':'));
    }

    @Test
    public void commonSuffixOfLengthTest() {
        StringUtilTest.checkNotCommonSuffix("abc", "abc", -1);
        StringUtilTest.checkNotCommonSuffix("abc", null, 0);
        StringUtilTest.checkNotCommonSuffix(null, null, 0);
        StringUtilTest.checkCommonSuffix("abc", "xx", 0);
        StringUtilTest.checkCommonSuffix("abc", "abc", 0);
        StringUtilTest.checkCommonSuffix("abc", "abc", 1);
        StringUtilTest.checkCommonSuffix("abc", "abc", 2);
        StringUtilTest.checkCommonSuffix("abc", "abc", 3);
        StringUtilTest.checkNotCommonSuffix("abc", "abc", 4);
        StringUtilTest.checkCommonSuffix("abcd", "cd", 1);
        StringUtilTest.checkCommonSuffix("abcd", "cd", 2);
        StringUtilTest.checkNotCommonSuffix("abcd", "cd", 3);
        StringUtilTest.checkCommonSuffix("abcd", "axcd", 1);
        StringUtilTest.checkCommonSuffix("abcd", "axcd", 2);
        StringUtilTest.checkNotCommonSuffix("abcd", "axcd", 3);
        StringUtilTest.checkNotCommonSuffix("abcx", "abcy", 1);
    }

    private static void checkNotCommonSuffix(String s, String p, int len) {
        Assert.assertFalse((boolean)StringUtilTest.checkCommonSuffixSymmetric(s, p, len));
    }

    private static void checkCommonSuffix(String s, String p, int len) {
        Assert.assertTrue((boolean)StringUtilTest.checkCommonSuffixSymmetric(s, p, len));
    }

    private static boolean checkCommonSuffixSymmetric(String s, String p, int len) {
        boolean sp = StringUtil.commonSuffixOfLength((String)s, (String)p, (int)len);
        boolean ps = StringUtil.commonSuffixOfLength((String)p, (String)s, (int)len);
        Assert.assertEquals((Object)sp, (Object)ps);
        return sp;
    }

    @Test(expected=NullPointerException.class)
    public void escapeCsvNull() {
        StringUtil.escapeCsv(null);
    }

    @Test
    public void escapeCsvEmpty() {
        String value;
        String expected = value = "";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvUnquoted() {
        String value;
        String expected = value = "something";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvAlreadyQuoted() {
        String value = "\"something\"";
        String expected = "\"something\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuote() {
        String value = "s\"";
        String expected = "\"s\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuoteInMiddle() {
        String value = "some text\"and more text";
        String expected = "\"some text\"\"and more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuoteInMiddleAlreadyQuoted() {
        String value = "\"some text\"and more text\"";
        String expected = "\"some text\"\"and more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedWords() {
        String value = "\"foo\"\"goo\"";
        String expected = "\"foo\"\"goo\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithAlreadyEscapedQuote() {
        String value = "foo\"\"goo";
        String expected = "foo\"\"goo";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvEndingWithQuote() {
        String value = "some\"";
        String expected = "\"some\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleQuote() {
        String value = "\"";
        String expected = "\"\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleQuoteAndCharacter() {
        String value = "\"f";
        String expected = "\"\"\"f\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvAlreadyEscapedQuote() {
        String value = "\"some\"\"";
        String expected = "\"some\"\"\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvQuoted() {
        String value;
        String expected = value = "\"foo,goo\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithLineFeed() {
        String value = "some text\n more text";
        String expected = "\"some text\n more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleLineFeedCharacter() {
        String value = "\n";
        String expected = "\"\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithMultipleLineFeedCharacter() {
        String value = "\n\n";
        String expected = "\"\n\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedAndLineFeedCharacter() {
        String value = " \" \n ";
        String expected = "\" \"\" \n \"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithLineFeedAtEnd() {
        String value = "testing\n";
        String expected = "\"testing\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithComma() {
        String value = "test,ing";
        String expected = "\"test,ing\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleComma() {
        String value = ",";
        String expected = "\",\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithSingleCarriageReturn() {
        String value = "\r";
        String expected = "\"\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithMultipleCarriageReturn() {
        String value = "\r\r";
        String expected = "\"\r\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCarriageReturn() {
        String value = "some text\r more text";
        String expected = "\"some text\r more text\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithQuotedAndCarriageReturnCharacter() {
        String value = "\"\r";
        String expected = "\"\"\"\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCarriageReturnAtEnd() {
        String value = "testing\r";
        String expected = "\"testing\r\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    @Test
    public void escapeCsvWithCRLFCharacter() {
        String value = "\r\n";
        String expected = "\"\r\n\"";
        StringUtilTest.escapeCsv(value, expected);
    }

    private static void escapeCsv(CharSequence value, CharSequence expected) {
        StringUtilTest.escapeCsv(value, expected, false);
    }

    private static void escapeCsvWithTrimming(CharSequence value, CharSequence expected) {
        StringUtilTest.escapeCsv(value, expected, true);
    }

    private static void escapeCsv(CharSequence value, CharSequence expected, boolean trimOws) {
        CharSequence escapedValue = value;
        for (int i = 0; i < 10; ++i) {
            escapedValue = StringUtil.escapeCsv((CharSequence)escapedValue, (boolean)trimOws);
            Assert.assertEquals((Object)expected, (Object)escapedValue.toString());
        }
    }

    @Test
    public void escapeCsvWithTrimming() {
        Assert.assertSame((Object)"", (Object)StringUtil.escapeCsv((CharSequence)"", (boolean)true));
        Assert.assertSame((Object)"ab", (Object)StringUtil.escapeCsv((CharSequence)"ab", (boolean)true));
        StringUtilTest.escapeCsvWithTrimming("", "");
        StringUtilTest.escapeCsvWithTrimming(" \t ", "");
        StringUtilTest.escapeCsvWithTrimming("ab", "ab");
        StringUtilTest.escapeCsvWithTrimming("a b", "a b");
        StringUtilTest.escapeCsvWithTrimming(" \ta \tb", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("a \tb \t", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("\t a \tb \t", "a \tb");
        StringUtilTest.escapeCsvWithTrimming("\"\t a b \"", "\"\t a b \"");
        StringUtilTest.escapeCsvWithTrimming(" \"\t a b \"\t", "\"\t a b \"");
        StringUtilTest.escapeCsvWithTrimming(" testing\t\n ", "\"testing\t\n\"");
        StringUtilTest.escapeCsvWithTrimming("\ttest,ing ", "\"test,ing\"");
    }

    @Test
    public void escapeCsvGarbageFree() {
        Assert.assertSame((Object)"1", (Object)StringUtil.escapeCsv((CharSequence)"1", (boolean)true));
        Assert.assertSame((Object)" 123 ", (Object)StringUtil.escapeCsv((CharSequence)" 123 ", (boolean)false));
        Assert.assertSame((Object)"\" 123 \"", (Object)StringUtil.escapeCsv((CharSequence)"\" 123 \"", (boolean)true));
        Assert.assertSame((Object)"\"\"", (Object)StringUtil.escapeCsv((CharSequence)"\"\"", (boolean)true));
        Assert.assertSame((Object)"123 \"\"", (Object)StringUtil.escapeCsv((CharSequence)"123 \"\"", (boolean)true));
        Assert.assertSame((Object)"123\"\"321", (Object)StringUtil.escapeCsv((CharSequence)"123\"\"321", (boolean)true));
        Assert.assertSame((Object)"\"123\"\"321\"", (Object)StringUtil.escapeCsv((CharSequence)"\"123\"\"321\"", (boolean)true));
    }

    @Test
    public void testUnescapeCsv() {
        Assert.assertEquals((Object)"", (Object)StringUtil.unescapeCsv((CharSequence)""));
        Assert.assertEquals((Object)"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\""));
        Assert.assertEquals((Object)"\"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\"\"\""));
        Assert.assertEquals((Object)"\"\"\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"\"\"\"\"\""));
        Assert.assertEquals((Object)"\"netty\"", (Object)StringUtil.unescapeCsv((CharSequence)"\"\"\"netty\"\"\""));
        Assert.assertEquals((Object)"netty", (Object)StringUtil.unescapeCsv((CharSequence)"netty"));
        Assert.assertEquals((Object)"netty", (Object)StringUtil.unescapeCsv((CharSequence)"\"netty\""));
        Assert.assertEquals((Object)"\r", (Object)StringUtil.unescapeCsv((CharSequence)"\"\r\""));
        Assert.assertEquals((Object)"\n", (Object)StringUtil.unescapeCsv((CharSequence)"\"\n\""));
        Assert.assertEquals((Object)"hello,netty", (Object)StringUtil.unescapeCsv((CharSequence)"\"hello,netty\""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvWithSingleQuote() {
        StringUtil.unescapeCsv((CharSequence)"\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvWithOddQuote() {
        StringUtil.unescapeCsv((CharSequence)"\"\"\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvWithCRAndWithoutQuote() {
        StringUtil.unescapeCsv((CharSequence)"\r");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvWithLFAndWithoutQuote() {
        StringUtil.unescapeCsv((CharSequence)"\n");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvWithCommaAndWithoutQuote() {
        StringUtil.unescapeCsv((CharSequence)",");
    }

    @Test
    public void escapeCsvAndUnEscapeCsv() {
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("netty");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("hello,netty");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("hello,\"netty\"");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\"");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv(",");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\r");
        StringUtilTest.assertEscapeCsvAndUnEscapeCsv("\n");
    }

    private static void assertEscapeCsvAndUnEscapeCsv(String value) {
        Assert.assertEquals((Object)value, (Object)StringUtil.unescapeCsv((CharSequence)StringUtil.escapeCsv((CharSequence)value)));
    }

    @Test
    public void testUnescapeCsvFields() {
        Assert.assertEquals(Collections.singletonList(""), (Object)StringUtil.unescapeCsvFields((CharSequence)""));
        Assert.assertEquals(Arrays.asList("", ""), (Object)StringUtil.unescapeCsvFields((CharSequence)","));
        Assert.assertEquals(Arrays.asList("a", ""), (Object)StringUtil.unescapeCsvFields((CharSequence)"a,"));
        Assert.assertEquals(Arrays.asList("", "a"), (Object)StringUtil.unescapeCsvFields((CharSequence)",a"));
        Assert.assertEquals(Collections.singletonList("\""), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"\"\"\""));
        Assert.assertEquals(Arrays.asList("\"", "\""), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"\"\"\",\"\"\"\""));
        Assert.assertEquals(Collections.singletonList("netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"netty"));
        Assert.assertEquals(Arrays.asList("hello", "netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"hello,netty"));
        Assert.assertEquals(Collections.singletonList("hello,netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"hello,netty\""));
        Assert.assertEquals(Arrays.asList("hello", "netty"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"hello\",\"netty\""));
        Assert.assertEquals(Arrays.asList("a\"b", "c\"d"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"a\"\"b\",\"c\"\"d\""));
        Assert.assertEquals(Arrays.asList("a\rb", "c\nd"), (Object)StringUtil.unescapeCsvFields((CharSequence)"\"a\rb\",\"c\nd\""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvFieldsWithCRWithoutQuote() {
        StringUtil.unescapeCsvFields((CharSequence)"a,\r");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvFieldsWithLFWithoutQuote() {
        StringUtil.unescapeCsvFields((CharSequence)"a,\r");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvFieldsWithQuote() {
        StringUtil.unescapeCsvFields((CharSequence)"a,\"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvFieldsWithQuote2() {
        StringUtil.unescapeCsvFields((CharSequence)"\",a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void unescapeCsvFieldsWithQuote3() {
        StringUtil.unescapeCsvFields((CharSequence)"a\"b,a");
    }

    @Test
    public void testSimpleClassName() throws Exception {
        StringUtilTest.testSimpleClassName(String.class);
    }

    @Test
    public void testSimpleInnerClassName() throws Exception {
        StringUtilTest.testSimpleClassName(TestClass.class);
    }

    private static void testSimpleClassName(Class<?> clazz) throws Exception {
        Package pkg = clazz.getPackage();
        String name = pkg != null ? clazz.getName().substring(pkg.getName().length() + 1) : clazz.getName();
        Assert.assertEquals((Object)name, (Object)StringUtil.simpleClassName(clazz));
    }

    @Test
    public void testEndsWith() {
        Assert.assertFalse((boolean)StringUtil.endsWith((CharSequence)"", (char)'u'));
        Assert.assertTrue((boolean)StringUtil.endsWith((CharSequence)"u", (char)'u'));
        Assert.assertTrue((boolean)StringUtil.endsWith((CharSequence)"-u", (char)'u'));
        Assert.assertFalse((boolean)StringUtil.endsWith((CharSequence)"-", (char)'u'));
        Assert.assertFalse((boolean)StringUtil.endsWith((CharSequence)"u-", (char)'u'));
    }

    @Test
    public void trimOws() {
        Assert.assertSame((Object)"", (Object)StringUtil.trimOws((CharSequence)""));
        Assert.assertEquals((Object)"", (Object)StringUtil.trimOws((CharSequence)" \t "));
        Assert.assertSame((Object)"a", (Object)StringUtil.trimOws((CharSequence)"a"));
        Assert.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)" a"));
        Assert.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)"a "));
        Assert.assertEquals((Object)"a", (Object)StringUtil.trimOws((CharSequence)" a "));
        Assert.assertSame((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"abc"));
        Assert.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"\tabc"));
        Assert.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"abc\t"));
        Assert.assertEquals((Object)"abc", (Object)StringUtil.trimOws((CharSequence)"\tabc\t"));
        Assert.assertSame((Object)"a\t b", (Object)StringUtil.trimOws((CharSequence)"a\t b"));
        Assert.assertEquals((Object)"", (Object)StringUtil.trimOws((CharSequence)"\t ").toString());
        Assert.assertEquals((Object)"a b", (Object)StringUtil.trimOws((CharSequence)"\ta b \t").toString());
    }

    @Test
    public void testJoin() {
        Assert.assertEquals((Object)"", (Object)StringUtil.join((CharSequence)",", Collections.emptyList()).toString());
        Assert.assertEquals((Object)"a", (Object)StringUtil.join((CharSequence)",", Collections.singletonList("a")).toString());
        Assert.assertEquals((Object)"a,b", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b")).toString());
        Assert.assertEquals((Object)"a,b,c", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b", "c")).toString());
        Assert.assertEquals((Object)"a,b,c,null,d", (Object)StringUtil.join((CharSequence)",", Arrays.asList("a", "b", "c", null, "d")).toString());
    }

    @Test
    public void testIsNullOrEmpty() {
        Assert.assertTrue((boolean)StringUtil.isNullOrEmpty(null));
        Assert.assertTrue((boolean)StringUtil.isNullOrEmpty((String)""));
        Assert.assertTrue((boolean)StringUtil.isNullOrEmpty((String)""));
        Assert.assertFalse((boolean)StringUtil.isNullOrEmpty((String)" "));
        Assert.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"\t"));
        Assert.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"\n"));
        Assert.assertFalse((boolean)StringUtil.isNullOrEmpty((String)"foo"));
        Assert.assertFalse((boolean)StringUtil.isNullOrEmpty((String)StringUtil.NEWLINE));
    }

    @Test
    public void testIndexOfWhiteSpace() {
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"", (int)0));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfWhiteSpace((CharSequence)" ", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)" ", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"\n", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"\n", (int)1));
        Assert.assertEquals((long)0L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"\t", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"\t", (int)1));
        Assert.assertEquals((long)3L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"foo\r\nbar", (int)1));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"foo\r\nbar", (int)10));
        Assert.assertEquals((long)7L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"foo\tbar\r\n", (int)6));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfWhiteSpace((CharSequence)"foo\tbar\r\n", (int)Integer.MAX_VALUE));
    }

    @Test
    public void testIndexOfNonWhiteSpace() {
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)"", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" ", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \t", (int)0));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \t\r\n", (int)0));
        Assert.assertEquals((long)2L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)0));
        Assert.assertEquals((long)2L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)1));
        Assert.assertEquals((long)4L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)4));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)10));
        Assert.assertEquals((long)-1L, (long)StringUtil.indexOfNonWhiteSpace((CharSequence)" \tfoo\r\n", (int)Integer.MAX_VALUE));
    }

    private static final class TestClass {
        private TestClass() {
        }
    }
}

