/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.Recycler;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class RecyclerTest {
    private static Recycler<HandledObject> newRecycler(int max) {
        return new Recycler<HandledObject>(max){

            protected HandledObject newObject(Recycler.Handle<HandledObject> handle) {
                return new HandledObject(handle);
            }
        };
    }

    @Test(timeout=5000L)
    public void testThreadCanBeCollectedEvenIfHandledObjectIsReferenced() throws Exception {
        final Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final AtomicBoolean collected = new AtomicBoolean();
        final AtomicReference<Object> reference = new AtomicReference<Object>();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                HandledObject object = (HandledObject)recycler.get();
                reference.set(object);
            }
        }){

            protected void finalize() throws Throwable {
                super.finalize();
                collected.set(true);
            }
        };
        Assert.assertFalse((boolean)collected.get());
        thread.start();
        thread.join();
        thread = null;
        while (!collected.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(50L);
        }
        ((HandledObject)reference.getAndSet(null)).recycle();
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleRecycle() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        object.recycle();
    }

    @Test(expected=IllegalStateException.class)
    public void testMultipleRecycleAtDifferentThread() throws InterruptedException {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        final HandledObject object = (HandledObject)recycler.get();
        final AtomicReference exceptionStore = new AtomicReference();
        Thread thread1 = new Thread(new Runnable(){

            @Override
            public void run() {
                object.recycle();
            }
        });
        thread1.start();
        thread1.join();
        Thread thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    object.recycle();
                }
                catch (IllegalStateException e) {
                    exceptionStore.set(e);
                }
            }
        });
        thread2.start();
        thread2.join();
        IllegalStateException exception = (IllegalStateException)exceptionStore.get();
        if (exception != null) {
            throw exception;
        }
    }

    @Test
    public void testRecycle() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(1024);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        HandledObject object2 = (HandledObject)recycler.get();
        Assert.assertSame((Object)object, (Object)object2);
        object2.recycle();
    }

    @Test
    public void testRecycleDisable() {
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(-1);
        HandledObject object = (HandledObject)recycler.get();
        object.recycle();
        HandledObject object2 = (HandledObject)recycler.get();
        Assert.assertNotSame((Object)object, (Object)object2);
        object2.recycle();
    }

    @Test
    public void testMaxCapacity() {
        RecyclerTest.testMaxCapacity(300);
        Random rand = new Random();
        for (int i = 0; i < 50; ++i) {
            RecyclerTest.testMaxCapacity(rand.nextInt(1000) + 256);
        }
    }

    private static void testMaxCapacity(int maxCapacity) {
        int i;
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(maxCapacity);
        HandledObject[] objects = new HandledObject[maxCapacity * 3];
        for (i = 0; i < objects.length; ++i) {
            objects[i] = (HandledObject)recycler.get();
        }
        for (i = 0; i < objects.length; ++i) {
            objects[i].recycle();
            objects[i] = null;
        }
        Assert.assertTrue((String)("The threadLocalCapacity (" + recycler.threadLocalCapacity() + ") must be <= maxCapacity (" + maxCapacity + ") as we not pool all new handles internally"), (maxCapacity >= recycler.threadLocalCapacity() ? 1 : 0) != 0);
    }

    @Test
    public void testRecycleAtDifferentThread() throws Exception {
        Recycler<HandledObject> recycler = new Recycler<HandledObject>(256, 10, 2, 10){

            protected HandledObject newObject(Recycler.Handle<HandledObject> handle) {
                return new HandledObject(handle);
            }
        };
        final HandledObject o = (HandledObject)recycler.get();
        final HandledObject o2 = (HandledObject)recycler.get();
        Thread thread = new Thread(){

            @Override
            public void run() {
                o.recycle();
                o2.recycle();
            }
        };
        thread.start();
        thread.join();
        Assert.assertSame((Object)recycler.get(), (Object)o);
        Assert.assertNotSame((Object)recycler.get(), (Object)o2);
    }

    @Test
    public void testMaxCapacityWithRecycleAtDifferentThread() throws Exception {
        int i;
        int maxCapacity = 4;
        Recycler<HandledObject> recycler = RecyclerTest.newRecycler(4);
        final HandledObject[] array = new HandledObject[12];
        for (i = 0; i < array.length; ++i) {
            array[i] = (HandledObject)recycler.get();
        }
        for (i = 0; i < 4; ++i) {
            array[i].recycle();
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (int i = 4; i < array.length; ++i) {
                    array[i].recycle();
                }
            }
        };
        thread.start();
        thread.join();
        Assert.assertEquals((long)4L, (long)recycler.threadLocalCapacity());
        Assert.assertEquals((long)1L, (long)recycler.threadLocalSize());
        for (int i2 = 0; i2 < array.length; ++i2) {
            recycler.get();
        }
        Assert.assertEquals((long)4L, (long)recycler.threadLocalCapacity());
        Assert.assertEquals((long)0L, (long)recycler.threadLocalSize());
    }

    @Test
    public void testDiscardingExceedingElementsWithRecycleAtDifferentThread() throws Exception {
        int maxCapacity = 32;
        final AtomicInteger instancesCount = new AtomicInteger(0);
        Recycler<HandledObject> recycler = new Recycler<HandledObject>(32, 2){

            protected HandledObject newObject(Recycler.Handle<HandledObject> handle) {
                instancesCount.incrementAndGet();
                return new HandledObject(handle);
            }
        };
        final HandledObject[] array = new HandledObject[64];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (HandledObject)recycler.get();
        }
        Assert.assertEquals((long)array.length, (long)instancesCount.get());
        instancesCount.set(0);
        Thread thread = new Thread(){

            @Override
            public void run() {
                for (HandledObject object : array) {
                    object.recycle();
                }
            }
        };
        thread.start();
        thread.join();
        Assert.assertEquals((long)0L, (long)instancesCount.get());
        for (int i = 0; i < array.length; ++i) {
            recycler.get();
        }
        Assert.assertTrue((String)("The instances count (" + instancesCount.get() + ") must be <= array.length (" + array.length + ") - maxCapacity (" + 32 + ") / 2 as we not pool all new handles internally"), (array.length - 16 <= instancesCount.get() ? 1 : 0) != 0);
    }

    static final class HandledObject {
        Recycler.Handle<HandledObject> handle;

        HandledObject(Recycler.Handle<HandledObject> handle) {
            this.handle = handle;
        }

        void recycle() {
            this.handle.recycle((Object)this);
        }
    }
}

