/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.AppendableCharSequence;
import org.junit.Assert;
import org.junit.Test;

public class AppendableCharSequenceTest {
    @Test
    public void testSimpleAppend() {
        AppendableCharSequenceTest.testSimpleAppend0(new AppendableCharSequence(128));
    }

    @Test
    public void testAppendString() {
        AppendableCharSequenceTest.testAppendString0(new AppendableCharSequence(128));
    }

    @Test
    public void testAppendAppendableCharSequence() {
        AppendableCharSequence seq = new AppendableCharSequence(128);
        String text = "testdata";
        AppendableCharSequence seq2 = new AppendableCharSequence(128);
        seq2.append((CharSequence)text);
        seq.append((CharSequence)seq2);
        Assert.assertEquals((Object)text, (Object)seq.toString());
        Assert.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
    }

    @Test
    public void testSimpleAppendWithExpand() {
        AppendableCharSequenceTest.testSimpleAppend0(new AppendableCharSequence(2));
    }

    @Test
    public void testAppendStringWithExpand() {
        AppendableCharSequenceTest.testAppendString0(new AppendableCharSequence(2));
    }

    @Test
    public void testSubSequence() {
        AppendableCharSequence master = new AppendableCharSequence(26);
        master.append((CharSequence)"abcdefghijlkmonpqrstuvwxyz");
        Assert.assertEquals((Object)"abcdefghij", (Object)master.subSequence(0, 10).toString());
    }

    @Test
    public void testEmptySubSequence() {
        AppendableCharSequence master = new AppendableCharSequence(26);
        master.append((CharSequence)"abcdefghijlkmonpqrstuvwxyz");
        AppendableCharSequence sub = master.subSequence(0, 0);
        Assert.assertEquals((long)0L, (long)sub.length());
        sub.append('b');
        Assert.assertEquals((long)98L, (long)sub.charAt(0));
    }

    private static void testSimpleAppend0(AppendableCharSequence seq) {
        String text = "testdata";
        for (int i = 0; i < text.length(); ++i) {
            seq.append(text.charAt(i));
        }
        Assert.assertEquals((Object)text, (Object)seq.toString());
        Assert.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
        seq.reset();
        Assert.assertEquals((long)0L, (long)seq.length());
    }

    private static void testAppendString0(AppendableCharSequence seq) {
        String text = "testdata";
        seq.append((CharSequence)text);
        Assert.assertEquals((Object)text, (Object)seq.toString());
        Assert.assertEquals((Object)text.substring(1, text.length() - 2), (Object)seq.substring(1, text.length() - 2));
        AppendableCharSequenceTest.assertEqualsChars(text, (CharSequence)seq);
        seq.reset();
        Assert.assertEquals((long)0L, (long)seq.length());
    }

    private static void assertEqualsChars(CharSequence seq1, CharSequence seq2) {
        Assert.assertEquals((long)seq1.length(), (long)seq2.length());
        for (int i = 0; i < seq1.length(); ++i) {
            Assert.assertEquals((long)seq1.charAt(i), (long)seq2.charAt(i));
        }
    }
}

