/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.ObjectCleaner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ObjectCleanerTest {
    private Thread temporaryThread;
    private Object temporaryObject;

    @Test(timeout=5000L)
    public void testCleanup() throws Exception {
        final AtomicBoolean freeCalled = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        this.temporaryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.temporaryThread.start();
        ObjectCleaner.register((Object)this.temporaryThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalled.set(true);
            }
        });
        latch.countDown();
        this.temporaryThread.join();
        Assert.assertFalse((boolean)freeCalled.get());
        this.temporaryThread = null;
        while (!freeCalled.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(100L);
        }
    }

    @Test(timeout=5000L)
    public void testCleanupContinuesDespiteThrowing() throws InterruptedException {
        final AtomicInteger freeCalledCount = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        this.temporaryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.temporaryThread.start();
        this.temporaryObject = new Object();
        ObjectCleaner.register((Object)this.temporaryThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalledCount.incrementAndGet();
                throw new RuntimeException("expected");
            }
        });
        ObjectCleaner.register((Object)this.temporaryObject, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalledCount.incrementAndGet();
                throw new RuntimeException("expected");
            }
        });
        latch.countDown();
        this.temporaryThread.join();
        Assert.assertEquals((long)0L, (long)freeCalledCount.get());
        this.temporaryThread = null;
        this.temporaryObject = null;
        while (freeCalledCount.get() != 2) {
            System.gc();
            System.runFinalization();
            Thread.sleep(100L);
        }
    }

    @Test(timeout=5000L)
    public void testCleanerThreadIsDaemon() throws Exception {
        this.temporaryObject = new Object();
        ObjectCleaner.register((Object)this.temporaryObject, (Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
        Thread cleanerThread = null;
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().equals(ObjectCleaner.CLEANER_THREAD_NAME)) continue;
            cleanerThread = thread;
            break;
        }
        Assert.assertNotNull(cleanerThread);
        Assert.assertTrue((boolean)cleanerThread.isDaemon());
    }
}

